
#include<cppinterface.h>
#include <string>
#include <xlw/Wrapper.h>
#include <xlw/ArgListFactory.h>
using std::string;
#include "PE_Test.h"
#pragma warning (disable : 4996)

CellMatrix SignTestResults(const NEMatrix& TradeHistory)
{
	ArgumentList Input("Input");     // Input data
	ArgumentList Output("Output");   // Test results	
	PE_Test* TestPtr;                // Pointer to the test object
	Wrapper<PE_Test> SmartTestPtr;   // Smart pointer to the test object

	// Create pointer to test object:
	ArgumentList args("Argument");
	args.add(static_cast<std::string>("name"), static_cast<std::string>("sign test"));	
	// For now, it doesn't work without casting, but Narinder Claire promised to fix it.
	TestPtr = ArgListFactory<PE_Test>::FactoryInstance().CreateT(args);
	SmartTestPtr = Wrapper<PE_Test>(TestPtr);
		
	// Split input data into 3 columns:
	MyArray TradedQuant(TradeHistory.rows());
	MyArray Bid(TradeHistory.rows());
	MyArray Ask(TradeHistory.rows());	
	for (unsigned long i = 0; i < TradeHistory.rows(); ++i)
	{	
		TradedQuant[i] = TradeHistory(i, 0);
		Bid[i] = TradeHistory(i, 1);
		Ask[i] = TradeHistory(i, 2);
	}
	Input.add("traded quantity", TradedQuant);
	Input.add("bid", Bid);
	Input.add("ask", Ask);	
	// Get test results:
	(*SmartTestPtr)(Input, Output);
	return Output.GetCellsArgumentValue("test results");
}

CellMatrix CorrTestResults(const NEMatrix& TradeHistory, double num_replic)
{
	ArgumentList Input("Input");          // Input data
	ArgumentList Output("Output");        // Test results
	PE_Test* TestPtr;                     // Pointer to the test object
	Wrapper<PE_Test> SmartTestPtr;		  // Smart pointer to the test object

	// Create pointer to test object:
	ArgumentList args("Argument");
	args.add(static_cast<std::string>("name"), static_cast<std::string>("correlation test"));
	TestPtr = ArgListFactory<PE_Test>::FactoryInstance().CreateT(args);
	SmartTestPtr = Wrapper<PE_Test>(TestPtr);
		
	// Split input data into 3 columns:
	MyArray TradedQuant(TradeHistory.rows());
	MyArray Bid(TradeHistory.rows());
	MyArray Ask(TradeHistory.rows());	
	for (unsigned long i = 0; i < TradeHistory.rows(); ++i)
	{	
		TradedQuant[i] = TradeHistory(i, 0);
		Bid[i] = TradeHistory(i, 1);
		Ask[i] = TradeHistory(i, 2);
	}
	Input.add("traded quantity", TradedQuant);
	Input.add("bid", Bid);
	Input.add("ask", Ask);
	Input.add("number of replications", num_replic);
	// Get test results:
	(*SmartTestPtr)(Input, Output);
	return Output.GetCellsArgumentValue("test results");
}

CellMatrix RunsTestResults(const NEMatrix& TradeHistory)
{
	ArgumentList Input("Input");     // Input data
	ArgumentList Output("Output");   // Test results
	PE_Test* TestPtr;                // Pointer to the test object
	Wrapper<PE_Test> SmartTestPtr;   // Smart pointer to the test object

	// Create pointer to test object:
	ArgumentList args("Argument");
	args.add(static_cast<std::string>("name"), static_cast<std::string>("runs test"));	
	TestPtr = ArgListFactory<PE_Test>::FactoryInstance().CreateT(args);		
	SmartTestPtr = Wrapper<PE_Test>(TestPtr);

	// Split input data into 3 columns:
	MyArray TradedQuant(TradeHistory.rows());
	MyArray Bid(TradeHistory.rows());
	MyArray Ask(TradeHistory.rows());	
	for (unsigned long i = 0; i < TradeHistory.rows(); ++i)
	{	
		TradedQuant[i] = TradeHistory(i, 0);
		Bid[i] = TradeHistory(i, 1);
		Ask[i] = TradeHistory(i, 2);
	}
	Input.add("traded quantity", TradedQuant);
	Input.add("bid", Bid);
	Input.add("ask", Ask);		
	// Get the test results:
	(*SmartTestPtr)(Input, Output);
	return Output.GetCellsArgumentValue("test results");
}