#include "decoder.h"
#include "executer.h"
bool Decoder::deCodeInstruction(Instruction inst) throw (ProcessorError)
{
  int ctrlSignal = 0;
  // set up the signals for operands
  switch (inst.opcode) 
    {
    case INSTRUCTION_PUSH:
      ctrlSignal = ctrlSignal | SIGNAL_WRITE_RESULT;
      break;
    case INSTRUCTION_XOR:
    case INSTRUCTION_AND:
    case INSTRUCTION_OR:
    case INSTRUCTION_ADD:
      ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND1;
      ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND2;
      ctrlSignal = ctrlSignal | SIGNAL_WRITE_RESULT;
      break;
    case INSTRUCTION_POP:
      // ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND1;
      break;
    case INSTRUCTION_PRINT:
      ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND1;
      ctrlSignal = ctrlSignal | SIGNAL_WRITE_RESULT;
      break;
    case INSTRUCTION_HALT:
      return false;
      break;
    default:
      throw ProcessorError(ERROR_INVALID_INSTRUCTION);
      break;
    }
  // set up the signal for individual instruction
  switch (inst.opcode) 
    {
    case INSTRUCTION_PUSH:
      // nothing needed
      break;
    case INSTRUCTION_XOR:
      ctrlSignal = ctrlSignal | SIGNAL_XOR;
      break;
    case INSTRUCTION_AND:
      ctrlSignal = ctrlSignal | SIGNAL_AND;
      break;
    case INSTRUCTION_OR:
      ctrlSignal = ctrlSignal | SIGNAL_OR;
      break;
    case INSTRUCTION_ADD:
      ctrlSignal = ctrlSignal | SIGNAL_ADD;
      break;
    case INSTRUCTION_POP:
      ctrlSignal = ctrlSignal | SIGNAL_POP;
      break;
    case INSTRUCTION_PRINT:
      ctrlSignal = ctrlSignal | SIGNAL_PRINT;
      break;
    default:
      throw ProcessorError(ERROR_INVALID_INSTRUCTION);
      break;
    }
  d_executer -> executeInstruction(ctrlSignal, inst.operand);
  return true;
}
