#include "executer.h"
#include "memory.h"
#include "fetcher.h"
void Executer::executeInstruction(int ctrlSignal, int inputvalue)
{
  int operand1 = -1; // initialize 
  int operand2 = -1;
  int result = inputvalue; // used for PUSH only
  if (ctrlSignal & SIGNAL_READ_OPERAND1) 
    { operand1 = e_memory -> Retrieve(); }
  if (ctrlSignal & SIGNAL_READ_OPERAND2) 
    { operand2 = e_memory -> Retrieve(); }
  if (ctrlSignal & SIGNAL_XOR)
    { 
      result = e_xorer.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_ADD)
    { 
      result = e_adder.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_OR)
    { 
      result = e_orer.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_AND)
    { 
      result = e_ander.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_PRINT)
    { 
      result = e_printer.doFunction(operand1); // ignore the return value
      // push the value back to memory
      result = operand1;
    }
  if (ctrlSignal & SIGNAL_POP)
    { 
      e_memory -> Retrieve();
    }
  if (ctrlSignal & SIGNAL_WRITE_RESULT) 
    { e_memory -> Store(result); }
  
}
