#ifndef EXECUTER_H_
#define EXECUTER_H_
using namespace std;
#include "instruction.h"
#include "functionunit.h"
// each signal uses a unique bit
const int SIGNAL_READ_OPERAND1 = 0x1;
const int SIGNAL_READ_OPERAND2 = 0x2;
const int SIGNAL_WRITE_RESULT  = 0x4;
const int SIGNAL_XOR           = 0x8;
const int SIGNAL_ADD           = 0x10;
const int SIGNAL_OR            = 0x20;
const int SIGNAL_AND           = 0x40;
const int SIGNAL_PRINT         = 0x80;
const int SIGNAL_POP           = 0x100;
class Writer;
class Memory;
class Fetcher;
class Executer
{
 public:
  void setMemory(Memory * datamemory) { e_memory = datamemory; }
  void setFetcher(Fetcher * instfetch) { e_fetcher = instfetch; }
  void executeInstruction(int ctrlCode, int inputvalue);
 private:
  Memory * e_memory;
  Fetcher * e_fetcher;
  Xorer e_xorer;
  Adder e_adder;
  Orer e_orer;
  Ander e_ander;
  Printer e_printer;
};
#endif /*EXECUTER_H_*/
