#ifndef INSTRUCTION_H_
#define INSTRUCTION_H_
#include <string>
#include <iostream>
using namespace std;

// stack machine model; all operations on the stack
// PUSH is the only instruction with one operand
// no other instruction needs any operand

const int INSTRUCTION_PUSH  = 0x10; 
const int INSTRUCTION_POP   = 0x11;
const int INSTRUCTION_XOR   = 0x12;
const int INSTRUCTION_AND   = 0x13;
const int INSTRUCTION_OR    = 0x14;
const int INSTRUCTION_ADD   = 0x15;
const int INSTRUCTION_PRINT = 0x16;
const int INSTRUCTION_HALT  = 0x17;

class Instruction 
{
public:
  bool needOperand(void) 
    {
      if (opcode == INSTRUCTION_PUSH) { return true; }
      return false;
    }
protected:
private:
  int opcode;
  int operand;
  friend istream & operator >> (istream & ist, Instruction & inst);
  friend class Decoder;
};
#endif /*INSTRUCTION_H_*/
