
using namespace std;
#include <iostream>
#include "fetcher.h"
#include "decoder.h"
#include "executer.h"
#include "memory.h"
#include "procerror.h"

int main(int argc, char * argv[])
{
  const int MEMORY_SIZE = 1024;
  if (argc != 2) 
    { cerr << "need a file name" << endl; return -1; }

	
  /* create objects for the functional units */
  Fetcher * instfetch = new Fetcher(argv[1]);		
  Decoder * instdec = new Decoder;
  Executer * instexec = new Executer;
  Memory * datamemory;
  try { datamemory = new Memory(MEMORY_SIZE);}
  catch (int errno)
    { cerr << "error number " << errno << endl; }
	
  /* each unit needs to know only the next unit */
  instfetch -> setDecoder(instdec);
  instdec -> setExecuter(instexec);
  instexec -> setMemory(datamemory);
  instexec -> setFetcher(instfetch);
  
	
  /* the processor start running */	
  bool progcontinue = true;
  while (progcontinue == true)
    {
      try { progcontinue = instfetch->fetchInstruction(); }
      catch (int errno)
	{ cerr << "error number " << errno << endl; }
    }
	
  delete instfetch;
  delete instdec;
  delete instexec;
  delete datamemory;
	
  return 0;
}
