#!/usr/local/bin/perl
# This program converts a human readable program, convert it to
# the binary format, and also show the result
#
# take two inputs: the input of text program and the output of binary program
#
$infile = $ARGV[0]; 
open(TEXTPROG, $infile) || die ("cannot open $infile");
$outfile = $ARGV[1]; 
open(BINPROG, ">$outfile") || die ("cannot open $outfile");
$opcode{"PUSH"}  = 0x10;
$opcode{"POP"}   = 0x11;
$opcode{"XOR"}   = 0x12;
$opcode{"AND"}   = 0x13;
$opcode{"OR"}    = 0x14;
$opcode{"ADD"}   = 0x15;
$opcode{"PRINT"} = 0x16;
$opcode{"HALT"}  = 0x17;

# two-phase approach. 
# first phase translates the program
while($oneline = <TEXTPROG>)
{
    $code = 0;
    $operand = -1;
    $oneline =~ s/\s*\n//; # remove the ending new line
    if ($oneline =~ /^PUSH ([0-9]+)$/)
    { 
	$code = $opcode{"PUSH"};
	$operand = $1; 
	if (($operand < 0) ||
	    ($operand > 15))
	{ print "WRONG, operand must be between 0 and 15\n"; }
    }
    else 
    {
	if (($oneline =~ /^POP$/) ||
	    ($oneline =~ /^XOR$/) ||
	    ($oneline =~ /^AND$/) ||
	    ($oneline =~ /^OR$/) ||
	    ($oneline =~ /^ADD$/) ||
	    ($oneline =~ /^HALT$/) ||
	    ($oneline =~ /^PRINT$/))
	{ 
	    $code = $opcode{$oneline}; 
	}
	else
	{ print "DEBUG, unknown instruction =$oneline=\n"; }
    }
    print BINPROG "$code ";
    print "DEBUG $oneline => opcode = $code\n";
    if ($operand != -1) # only for PUSH
    { print BINPROG $operand; }
    print BINPROG "\n";
}
close (TEXTPROG);
close (BINPROG);
   
