#include "decoder.h"
#include "executer.h"
#include "instruction.h"
#include "flipflop.h"
int Decoder :: d_halt = 1;

void Decoder::deCodeInstruction(int inst) throw (ProcessorError)
{
  int instOpcode = 0, counter = 0, instOperand = 0;
  instOpcode = inst;
  instOperand = (inst & 63);
  while(counter < 6){
	instOpcode = instOpcode/2;
	counter++;
  }
  int ctrlSignal = 0;
  switch (instOpcode) 
    {
    case INSTRUCTION_PUSH:
      ctrlSignal = ctrlSignal | SIGNAL_WRITE_RESULT;
      break;
    case INSTRUCTION_XOR:
    case INSTRUCTION_AND:
    case INSTRUCTION_OR:
    case INSTRUCTION_ADD:
      ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND1;
      ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND2;
      ctrlSignal = ctrlSignal | SIGNAL_WRITE_RESULT;
      break;
    case INSTRUCTION_POP:
      break;
    case INSTRUCTION_PRINT:
      ctrlSignal = ctrlSignal | SIGNAL_READ_OPERAND1;
      ctrlSignal = ctrlSignal | SIGNAL_WRITE_RESULT;
      break;
    case INSTRUCTION_HALT:
      d_halt = 5;
      break;
    case INSTRUCTION_NOOP:
      break;
    default:
      throw ProcessorError(ERROR_INVALID_INSTRUCTION);
      break;
    }
  switch (instOpcode) 
    {
    case INSTRUCTION_PUSH:
      break;
    case INSTRUCTION_XOR:
      ctrlSignal = ctrlSignal | SIGNAL_XOR;
      break;
    case INSTRUCTION_AND:
      ctrlSignal = ctrlSignal | SIGNAL_AND;
      break;
    case INSTRUCTION_OR:
      ctrlSignal = ctrlSignal | SIGNAL_OR;
      break;
    case INSTRUCTION_ADD:
      ctrlSignal = ctrlSignal | SIGNAL_ADD;
      break;
    case INSTRUCTION_POP:
      ctrlSignal = ctrlSignal | SIGNAL_POP;
      break;
    case INSTRUCTION_PRINT:
      ctrlSignal = ctrlSignal | SIGNAL_PRINT;
      break;
    case INSTRUCTION_NOOP:
      break;
    case INSTRUCTION_HALT:
      break;
    default:
      throw ProcessorError(ERROR_INVALID_INSTRUCTION);
      break;
    }
  
  int counter2 = 0;
  while(counter2 < 6)
  {
	  ctrlSignal = ctrlSignal*2;
	  counter2++;
  }
  int ctrl_instOperand = (ctrlSignal + instOperand);
  d_executerFF -> setStorage(ctrl_instOperand);
}

int Decoder::checkHaltStatus(void)
{
	return (d_halt);
}
