#ifndef DECODER_H_
#define DECODER_H_
using namespace std;
#include "executer.h"
#include "procerror.h"
#include "stage.h"
#include "flipflop.h"
class Decoder : public Stage
{
public:
  void deCodeInstruction(int inst) throw (ProcessorError);
  void sendValue(int ff_decoderval)
  {
	this->deCodeInstruction(ff_decoderval);	
  }
  int checkHaltStatus(void);
  void setExecuterFF(FlipFlop * execFF) {d_executerFF = execFF;}
private:
	int d_ffvalstore;
	static int d_halt;
	FlipFlop * d_executerFF;
};
#endif /*DECODER_H_*/
