#include "executer.h"
#include "memory.h"
#include "fetcher.h"
void Executer::executeInstruction(int ctrl_Inputvalue)
{
  int operand1 = -1; // initialize 
  int operand2 = -1;
  int ctrlSignal = ctrl_Inputvalue;
  int result = (ctrl_Inputvalue & 63); // used for PUSH only
  int counter = 0;
  while(counter < 6)
  {
	ctrlSignal = ctrlSignal/2;
	counter++;
  }
  if (ctrlSignal & SIGNAL_READ_OPERAND1) 
    { operand1 = e_memory -> Retrieve(); }
  if (ctrlSignal & SIGNAL_READ_OPERAND2) 
    { operand2 = e_memory -> Retrieve(); }
  if (ctrlSignal & SIGNAL_XOR)
    { 
      result = e_xorer.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_ADD)
    { 
      result = e_adder.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_OR)
    { 
      result = e_orer.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_AND)
    { 
      result = e_ander.doFunction(operand1, operand2); 
    }
  if (ctrlSignal & SIGNAL_PRINT)
    { 
      result = e_printer.doFunction(operand1); // ignore the return value
      result = operand1;
    }
  if (ctrlSignal & SIGNAL_POP)
    { 
     e_memory -> Retrieve();
    }
  if (ctrlSignal & SIGNAL_WRITE_RESULT) 
    { e_memory -> Store(result); }
}
