#ifndef EXECUTER_H_
#define EXECUTER_H_
using namespace std;
#include "functionunit.h"
#include "stage.h"
// each signal uses a unique bit
const int SIGNAL_READ_OPERAND1 = 0x1;
const int SIGNAL_READ_OPERAND2 = 0x2;
const int SIGNAL_WRITE_RESULT  = 0x4;
const int SIGNAL_XOR           = 0x8;
const int SIGNAL_ADD           = 0x10;
const int SIGNAL_OR            = 0x20;
const int SIGNAL_AND           = 0x40;
const int SIGNAL_PRINT         = 0x80;
const int SIGNAL_POP           = 0x100;
class Memory;
class Fetcher;
class Executer : public Stage
{
 public:
  void setMemory(Memory * datamemory) { e_memory = datamemory; }
  void executeInstruction(int ctrl_Inputvalue);
  void sendValue(int ff_execval) 
  {
	this->executeInstruction(ff_execval);
  }
  int checkHaltStatus(void) {return (1);}

 private:
  Memory * e_memory;
  Xorer e_xorer;
  Adder e_adder;
  Orer e_orer;
  Ander e_ander;
  Printer e_printer;
  int e_ffvalstore;
};
#endif /*EXECUTER_H_*/
