#include "fetcher.h"
#include "decoder.h"
#include <iostream>
#include "stage.h"
#include "flipflop.h"
#include "instruction.h"
Fetcher::Fetcher(char * filename): f_inststream(filename, ios::in)
{
}

bool Fetcher::f_checkEof = true;

bool Fetcher::f_checkFile = true;

void Fetcher::fetchInstruction(void)
{
  int inst;
  if (! f_inststream) {
	f_checkFile = false;
  }
  else if (! f_inststream.eof())
    { 
      f_inststream >> inst;
      f_decoderFF->setStorage(inst);
    }
  else
    {
      f_checkEof = false;
      f_decoderFF->setStorage(INSTRUCTION_NOOP);
    }
}

int Fetcher:: checkHaltStatus(void)
{
	if ((f_checkFile == true)&&(f_checkEof == true))
	{
		return (1);
	}
	else if (f_checkFile == false)
	{
		return (2);
	}
	else if (f_checkEof == false)
	{
		return (3);
 	}
	else 
	{
		return (2);
	}
}

