#ifndef FUNCTIONUNIT_H_
#define FUNCTIONUNIT_H_
using namespace std;
#include <iostream>
class FunctionUnit // abstract class
{
 public:
  virtual int doFunction(int operand1, int operand2 = 0) = 0;
};

class Xorer: public FunctionUnit
{
 public:
  int doFunction(int operand1, int operand2) { return (operand1 ^ operand2); }
};

class Adder: public FunctionUnit
{
 public:
  int doFunction(int operand1, int operand2) { return (operand1 + operand2); }
};

class Orer: public FunctionUnit
{
 public:
  int doFunction(int operand1, int operand2) { return (operand1 | operand2); }
};

class Ander: public FunctionUnit
{
 public:
  int doFunction(int operand1, int operand2) { return (operand1 & operand2); }
};

class Printer: public FunctionUnit
{
 public:
  int doFunction(int operand1, int operand2 = 0) 
    { 
      cout << operand1 << endl;
      return 0; // should be ingored
    }
};

#endif /*FUNCTIONUNIT_H_*/
