using namespace std;
#include <iostream>
#include "fetcher.h"
#include "decoder.h"
#include "executer.h"
#include "memory.h"
#include "procerror.h"
#include "flipflop.h"
#include "clock.h"

int main(int argc, char * argv[])
{
  const int MEMORY_SIZE = 1024;
  if (argc != 2) 
    { cerr << "need a file name" << endl; return -1; }

	
  /* create objects for the functional units */
  Fetcher * instfetch = new Fetcher(argv[1]);		
  Decoder * instdec = new Decoder;
  Executer * instexec = new Executer;
  Memory * datamemory;
  try { datamemory = new Memory(MEMORY_SIZE);}
  catch (int errno)
    { cerr << "error number " << errno << endl; }
  FlipFlop * fetch_ff = new FlipFlop(instfetch);
  FlipFlop * decoder_ff = new FlipFlop(instdec);
  FlipFlop * executer_ff = new FlipFlop(instexec);
  Clock * mainclk = new Clock; 
	
  /* each unit needs to know only the next unit */
  instexec -> setMemory(datamemory);
  instfetch -> setDecoderFF(decoder_ff);
  instdec -> setExecuterFF(executer_ff);
  fetch_ff -> setStorage(0);  
  decoder_ff -> setStorage(0);
  executer_ff -> setStorage(0);
  mainclk -> setFFfetcher(fetch_ff);  
  mainclk -> setFFdecoder(decoder_ff);
  mainclk -> setFFexecuter(executer_ff);
 
  /* the processor start running */	
  bool noHalt = true;
  int stopStatus = 0, eofCount = 0;
  while (noHalt)  
  {
      try { mainclk->sendClock();}   
      catch (int errno)
	{ cerr << "error number " << errno << endl; }
      stopStatus = mainclk->checkHalt();
      if(stopStatus == 1)
	{
		noHalt = true;
	}
      else if (stopStatus == 2)
	{
		noHalt = false;
	}
      else if (stopStatus == 3)
	{
		if(eofCount == 2){
			noHalt = false;
		}
		else{
			eofCount++;
			noHalt = true;
		}
	}
    for(int j=0; j<1000; j++);  // empty loop so that all three stages are done safely
    }
	
  delete instfetch;
  delete instdec;
  delete instexec;
  delete datamemory;
  delete fetch_ff;
  delete decoder_ff;
  delete executer_ff;
  delete mainclk;	

  return 0;
}
