#include "memory.h"

Memory::Memory(int size) throw (ProcessorError)
{
  m_size = 0; // initialize in case of an exception
  if (size <= 0) 
    { throw ProcessorError(ERROR_MEMORY_SIZE); }
  m_size = size;
  m_storage = new int[m_size];
}
Memory::~Memory()
{
  if (m_storage) { delete [] m_storage; }
}
int Memory::Retrieve(void) throw (ProcessorError)
{
  if (m_top < 0) 
    { throw ProcessorError(ERROR_MEMORY_UNDERFLOW); }
  m_top --; // if there is one element, the index is zero
  int value = m_storage[m_top];
  return value;
}

void Memory::Store(int value) throw (ProcessorError)
{
  if (m_top >= m_size) 
    { throw ProcessorError(ERROR_MEMORY_OVERFLOW); }
   value = value & MEMORY_WIDTH; // only four bits are allowed
  m_storage[m_top] = value;
  m_top ++;
}

int Memory::Read(void) const
{
  return (m_storage[m_top]);
}

void Memory::Print(void) const
{
  for (int top = 0; top < m_top; top ++)
    { cout << m_storage[top] << " "; }
  cout << endl;
}
