/*
 * Decompiled with CFR 0.152.
 */
package project1;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.jdesktop.layout.GroupLayout;
import project1.MyImage;
import project1.MyPanel;
import project1.RgbFilter;

public class MainJFrame
extends JFrame {
    private JMenuItem About;
    private JOptionPane AboutPane;
    private JOptionPane ExitPane;
    private JMenu File;
    private JMenuItem FileExit;
    private JMenuItem FileOpen;
    private JMenuItem FileSave;
    private JMenu Help;
    private JMenuBar MenuBar;
    private JMenu Process;
    private JMenuItem Process_Edge;
    private JMenuItem Process_Intelligent;
    private JMenuItem Process_Orig;
    private JMenuItem Process_Sim;
    private JFileChooser jFileChooser1;
    private MyPanel MyJPanel1 = null;
    private MyPanel MyJPanel2 = null;
    private MyPanel MyJPanel3 = null;
    private MyPanel MyJPanel4 = null;
    MyImage jimg = null;
    MyImage[] top3Images;
    File input_file = null;

    public MainJFrame() {
        this.initComponents();
        this.jFileChooser1 = new JFileChooser();
    }

    private void initComponents() {
        this.jFileChooser1 = new JFileChooser();
        this.AboutPane = new JOptionPane();
        this.ExitPane = new JOptionPane();
        this.MenuBar = new JMenuBar();
        this.File = new JMenu();
        this.FileOpen = new JMenuItem();
        this.FileSave = new JMenuItem();
        this.FileExit = new JMenuItem();
        this.Process = new JMenu();
        this.Process_Edge = new JMenuItem();
        this.Process_Sim = new JMenuItem();
        this.Process_Intelligent = new JMenuItem();
        this.Process_Orig = new JMenuItem();
        this.Help = new JMenu();
        this.About = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.File.setText("File");
        this.FileOpen.setText("Open");
        this.FileOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.FileOpenActionPerformed(evt);
            }
        });
        this.File.add(this.FileOpen);
        this.FileSave.setText("Save");
        this.FileSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.FileSaveActionPerformed(evt);
            }
        });
        this.File.add(this.FileSave);
        this.FileExit.setText("Exit");
        this.FileExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.FileExitActionPerformed(evt);
            }
        });
        this.File.add(this.FileExit);
        this.MenuBar.add(this.File);
        this.Process.setText("Process");
        this.Process_Edge.setText("Edge");
        this.Process_Edge.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ProcessEdgeActionPerformed(evt);
            }
        });
        this.Process.add(this.Process_Edge);
        this.Process_Sim.setText("Simple Analysis");
        this.Process_Sim.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ProcessSimpleActionPreformed(evt);
            }
        });
        this.Process.add(this.Process_Sim);
        this.Process_Intelligent.setText("Intelligent Analysis");
        this.Process_Intelligent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ProcessIntelligentActionPreformed(evt);
            }
        });
        this.Process.add(this.Process_Intelligent);
        this.Process_Orig.setText("Original");
        this.Process_Orig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.ProcessOriginalActionPreformed(evt);
            }
        });
        this.Process.add(this.Process_Orig);
        this.MenuBar.add(this.Process);
        this.Help.setText("Help");
        this.About.setText("About");
        this.About.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                MainJFrame.this.HelpAboutActionPreformed(evt);
            }
        });
        this.Help.add(this.About);
        this.MenuBar.add(this.Help);
        this.setJMenuBar(this.MenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(0, 279, Short.MAX_VALUE));
        this.pack();
    }

    private void HelpAboutActionPreformed(ActionEvent evt) {
        this.AboutPane = new JOptionPane();
        JOptionPane.showMessageDialog(this, "Questions? Contact Nik: http://www.stat.purdue.edu/~ntuzov/");
    }

    private void ProcessIntelligentActionPreformed(ActionEvent evt) {
        this.top3Images = new MyImage[3];
        double[] top3Values = new double[3];
        double Smult = 1.75;
        double Emult = 0.5;
        if (this.jimg != null) {
            String[] tempV;
            this.jimg.makeIntelligent();
            top3Values[0] = 99999.0;
            top3Values[1] = 99999.0;
            top3Values[2] = 99999.0;
            this.top3Images[0] = null;
            this.top3Images[1] = null;
            this.top3Images[2] = null;
            String dirPath = this.input_file.getPath();
            int tindex = dirPath.lastIndexOf("/");
            dirPath = dirPath.substring(0, tindex + 1);
            File T_file = new File(dirPath);
            for (String sFile : tempV = T_file.list()) {
                if (!sFile.endsWith(".rgb") || sFile.compareTo(this.input_file.getName()) == 0) continue;
                MyImage tempImage = new MyImage(dirPath + sFile);
                tempImage.makeIntelligent();
                double Sum = 0.0;
                double SumE = 0.0;
                double tSe = 0.0;
                double tS = 0.0;
                for (int x = 0; x < 32; ++x) {
                    tS = Math.pow(this.jimg.retHistValue(0, x) - tempImage.retHistValue(0, x), 2.0);
                    tS += Math.pow(this.jimg.retHistValue(1, x) - tempImage.retHistValue(1, x), 2.0);
                    Sum += Math.sqrt(tS += Math.pow(this.jimg.retHistValue(2, x) - tempImage.retHistValue(2, x), 2.0));
                }
                SumE = Math.abs(this.jimg.retNEdges() - tempImage.retNEdges());
                if (Smult * Sum + Emult * SumE < top3Values[0]) {
                    top3Values[2] = top3Values[1];
                    this.top3Images[2] = this.top3Images[1];
                    top3Values[1] = top3Values[0];
                    this.top3Images[1] = this.top3Images[0];
                    top3Values[0] = Smult * Sum + Emult * SumE;
                    this.top3Images[0] = tempImage;
                    continue;
                }
                if (Smult * Sum + Emult * SumE < top3Values[1]) {
                    top3Values[2] = top3Values[1];
                    this.top3Images[2] = this.top3Images[1];
                    top3Values[1] = Smult * Sum + Emult * SumE;
                    this.top3Images[1] = tempImage;
                    continue;
                }
                if (!(Smult * Sum + Emult * SumE < top3Values[2])) continue;
                top3Values[2] = Smult * Sum + Emult * SumE;
                this.top3Images[2] = tempImage;
            }
            System.out.println(top3Values[0] + " " + top3Values[1] + " " + top3Values[2] + "\n");
            this.jimg.ScaleImage();
            this.jimg.turnOnImagePrint();
            this.MyJPanel1.getParent().remove(this.MyJPanel1);
            if (this.MyJPanel2 != null) {
                this.MyJPanel2.getParent().remove(this.MyJPanel2);
            }
            if (this.MyJPanel3 != null) {
                this.MyJPanel3.getParent().remove(this.MyJPanel3);
            }
            if (this.MyJPanel4 != null) {
                this.MyJPanel4.getParent().remove(this.MyJPanel4);
            }
            this.MyJPanel1 = new MyPanel(this.jimg);
            this.MyJPanel1.SetNumber(1);
            this.setLayout(new GridLayout(2, 2));
            this.getContentPane().add(this.MyJPanel1);
            if (this.top3Images[0] != null) {
                this.top3Images[0].ScaleImage();
                this.MyJPanel2 = new MyPanel(this.top3Images[0]);
                this.MyJPanel2.SetNumber(2);
                this.getContentPane().add(this.MyJPanel2);
            }
            if (this.top3Images[1] != null) {
                this.top3Images[1].ScaleImage();
                this.MyJPanel3 = new MyPanel(this.top3Images[1]);
                this.MyJPanel3.SetNumber(3);
                this.getContentPane().add(this.MyJPanel3);
            }
            if (this.top3Images[2] != null) {
                this.top3Images[2].ScaleImage();
                this.MyJPanel4 = new MyPanel(this.top3Images[2]);
                this.MyJPanel4.SetNumber(4);
                this.getContentPane().add(this.MyJPanel4);
            }
            this.setPreferredSize(new Dimension(815, 650));
            this.pack();
            this.MyJPanel1.repaint();
            if (this.MyJPanel2 != null) {
                this.MyJPanel2.repaint();
            }
            if (this.MyJPanel3 != null) {
                this.MyJPanel3.repaint();
            }
            if (this.MyJPanel4 != null) {
                this.MyJPanel3.repaint();
            }
        }
    }

    private void ProcessSimpleActionPreformed(ActionEvent evt) {
        this.top3Images = new MyImage[3];
        double[] top3Values = new double[3];
        if (this.jimg != null) {
            String[] tempV;
            this.jimg.makeHist();
            top3Values[0] = 99999.0;
            top3Values[1] = 99999.0;
            top3Values[2] = 99999.0;
            String dirPath = this.input_file.getPath();
            int tindex = dirPath.lastIndexOf("/");
            dirPath = dirPath.substring(0, tindex + 1);
            File T_file = new File(dirPath);
            for (String sFile : tempV = T_file.list()) {
                if (!sFile.endsWith(".rgb") || sFile.compareTo(this.input_file.getName()) == 0) continue;
                MyImage tempImage = new MyImage(dirPath + sFile);
                tempImage.makeHist();
                double Sum = 0.0;
                double tS = 0.0;
                for (int x = 0; x < 8; ++x) {
                    tS = Math.pow(this.jimg.retHistValue(0, x) - tempImage.retHistValue(0, x), 2.0);
                    tS += Math.pow(this.jimg.retHistValue(1, x) - tempImage.retHistValue(1, x), 2.0);
                    Sum += Math.sqrt(tS += Math.pow(this.jimg.retHistValue(2, x) - tempImage.retHistValue(2, x), 2.0));
                }
                if (Sum < top3Values[0]) {
                    top3Values[2] = top3Values[1];
                    this.top3Images[2] = this.top3Images[1];
                    top3Values[1] = top3Values[0];
                    this.top3Images[1] = this.top3Images[0];
                    top3Values[0] = Sum;
                    this.top3Images[0] = tempImage;
                    continue;
                }
                if (Sum < top3Values[1]) {
                    top3Values[2] = top3Values[1];
                    this.top3Images[2] = this.top3Images[1];
                    top3Values[1] = Sum;
                    this.top3Images[1] = tempImage;
                    continue;
                }
                if (!(Sum < top3Values[2])) continue;
                top3Values[2] = Sum;
                this.top3Images[2] = tempImage;
            }
            this.jimg.turnOnImagePrint();
            this.MyJPanel1.getParent().remove(this.MyJPanel1);
            if (this.MyJPanel2 != null) {
                this.MyJPanel2.getParent().remove(this.MyJPanel2);
            }
            if (this.MyJPanel3 != null) {
                this.MyJPanel3.getParent().remove(this.MyJPanel3);
            }
            if (this.MyJPanel4 != null) {
                this.MyJPanel4.getParent().remove(this.MyJPanel4);
            }
            this.jimg.ScaleImage();
            this.MyJPanel1 = new MyPanel(this.jimg);
            this.MyJPanel1.SetNumber(1);
            this.setLayout(new GridLayout(2, 2));
            this.getContentPane().add(this.MyJPanel1);
            if (this.top3Images[0] != null) {
                this.top3Images[0].ScaleImage();
                this.MyJPanel2 = new MyPanel(this.top3Images[0]);
                this.MyJPanel2.SetNumber(2);
                this.getContentPane().add(this.MyJPanel2);
            }
            if (this.top3Images[1] != null) {
                this.top3Images[1].ScaleImage();
                this.MyJPanel3 = new MyPanel(this.top3Images[1]);
                this.MyJPanel3.SetNumber(3);
                this.getContentPane().add(this.MyJPanel3);
            }
            if (this.top3Images[2] != null) {
                this.top3Images[2].ScaleImage();
                this.MyJPanel4 = new MyPanel(this.top3Images[2]);
                this.MyJPanel4.SetNumber(4);
                this.getContentPane().add(this.MyJPanel4);
            }
            this.setPreferredSize(new Dimension(815, 650));
            this.pack();
            this.MyJPanel1.repaint();
            if (this.MyJPanel2 != null) {
                this.MyJPanel2.repaint();
            }
            if (this.MyJPanel3 != null) {
                this.MyJPanel3.repaint();
            }
            if (this.MyJPanel4 != null) {
                this.MyJPanel3.repaint();
            }
        } else {
            System.out.println("Open an Image first!\n");
        }
    }

    private void ProcessOriginalActionPreformed(ActionEvent evt) {
        if (this.jimg != null) {
            this.jimg.turnOnImagePrint();
            this.MyJPanel1.repaint();
        }
    }

    private void ProcessEdgeActionPerformed(ActionEvent evt) {
        if (this.jimg != null) {
            System.out.println("Calling Edge Process...\n");
            this.jimg.ProcessEdge();
            this.jimg.turnOnEdgePrint();
            this.MyJPanel1.repaint();
        } else {
            System.out.println("Image is null can't edge process\n");
        }
    }

    private void FileExitActionPerformed(ActionEvent evt) {
        this.ExitPane = new JOptionPane();
        Object[] tempStr = new String[]{"Yes", "No"};
        int n = JOptionPane.showOptionDialog(this, "Are you sure you want to quit?", "Exit", 0, 3, null, tempStr, "No");
        if (n == 0) {
            System.exit(0);
        }
    }

    private void FileSaveActionPerformed(ActionEvent evt) {
        if (this.jimg != null && this.MyJPanel1 != null && this.jimg.n_edges != 0) {
            File fileName = null;
            String newName = new String();
            newName = this.input_file.getPath();
            int n = newName.lastIndexOf(".rgb");
            newName = newName.substring(0, n);
            newName = newName + "e.rgb";
            fileName = new File(newName);
            try {
                DataOutputStream edgefile = new DataOutputStream(new FileOutputStream(fileName));
                edgefile.write(this.jimg.yres & 0xFF);
                edgefile.write(this.jimg.yres >> 8 & 0xFF);
                edgefile.write(this.jimg.xres & 0xFF);
                edgefile.write(this.jimg.xres >> 8 & 0xFF);
                for (int y = 0; y < this.jimg.yres; ++y) {
                    for (int x = 0; x < this.jimg.xres; ++x) {
                        edgefile.writeByte(this.jimg.my_edge[y][x].getRed());
                        edgefile.writeByte(this.jimg.my_edge[y][x].getGreen());
                        edgefile.writeByte(this.jimg.my_edge[y][x].getBlue());
                    }
                }
                edgefile.close();
            }
            catch (IOException exp) {
                System.out.println("Failed On save because of exception");
            }
        }
    }

    private void FileOpenActionPerformed(ActionEvent evt) {
        this.jFileChooser1.setFileFilter(new RgbFilter());
        int returnVal = this.jFileChooser1.showOpenDialog(this);
        if (returnVal == 0) {
            this.input_file = this.jFileChooser1.getSelectedFile();
            this.jimg = new MyImage(this.input_file.getPath());
            this.jimg.printEdge = 0;
            if (this.MyJPanel1 != null) {
                this.MyJPanel1.getParent().remove(this.MyJPanel1);
            }
            if (this.MyJPanel2 != null) {
                this.MyJPanel2.getParent().remove(this.MyJPanel2);
            }
            if (this.MyJPanel3 != null) {
                this.MyJPanel3.getParent().remove(this.MyJPanel3);
            }
            if (this.MyJPanel4 != null) {
                this.MyJPanel4.getParent().remove(this.MyJPanel4);
            }
            this.MyJPanel2 = null;
            this.MyJPanel3 = null;
            this.MyJPanel4 = null;
            this.setLayout(new GridLayout(1, 1));
            this.MyJPanel1 = new MyPanel(this.jimg);
            this.setPreferredSize(new Dimension(this.jimg.xres + 15, this.jimg.yres + 50));
            this.getContentPane().add(this.MyJPanel1);
            this.pack();
            this.MyJPanel1.repaint();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new MainJFrame().setVisible(true);
            }
        });
    }
}

