/*
 * Decompiled with CFR 0.152.
 */
package project1;

import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class MyImage {
    public Color[][] original;
    public Color[][] my_edge;
    public int[][] my_hist;
    public int n_edges;
    public int xres;
    public int yres;
    public int printEdge = 0;
    int EdgeThreshold = 18;

    public MyImage(String fileName) {
        try {
            DataInputStream imgfile = new DataInputStream(new FileInputStream(fileName));
            byte[] yindata = new byte[2];
            imgfile.read(yindata);
            this.yres = yindata[0] < 0 ? yindata[0] + 256 + 256 * yindata[1] : yindata[0] + 256 * yindata[1];
            byte[] xindata = new byte[2];
            imgfile.read(xindata);
            this.xres = xindata[0] < 0 ? xindata[0] + 256 + 256 * xindata[1] : xindata[0] + 256 * xindata[1];
            if (this.xres < 0 || this.yres < 0) {
                return;
            }
            this.original = new Color[this.yres][this.xres];
            for (int ycoor = 0; ycoor < this.yres; ++ycoor) {
                for (int xcoor = 0; xcoor < this.xres; ++xcoor) {
                    this.original[ycoor][xcoor] = new Color(imgfile.readUnsignedByte(), imgfile.readUnsignedByte(), imgfile.readUnsignedByte());
                }
            }
            imgfile.close();
        }
        catch (IOException exp) {
            System.out.println("IO error");
        }
        this.n_edges = 0;
    }

    public void drawImage(Graphics gfx) {
        for (int ycoor = 0; ycoor < this.yres; ++ycoor) {
            for (int xcoor = 0; xcoor < this.xres; ++xcoor) {
                if (this.printEdge == 0) {
                    gfx.setColor(this.original[ycoor][xcoor]);
                } else {
                    gfx.setColor(this.my_edge[ycoor][xcoor]);
                }
                gfx.fillRect(xcoor, ycoor, 1, 1);
            }
        }
    }

    public void turnOnEdgePrint() {
        this.printEdge = 1;
    }

    public void turnOnImagePrint() {
        this.printEdge = 0;
    }

    public void makeIntelligent() {
        int y;
        int x;
        int nBins = 32;
        this.my_hist = new int[3][32];
        if (this.n_edges == 0) {
            boolean temp1 = false;
            double tGrayV = 0.0;
            double tGrayL = 0.0;
            double tGrayR = 0.0;
            double tGrayT = 0.0;
            double tGrayB = 0.0;
            this.n_edges = 0;
            System.out.println("Starting Edge Processing...\n");
            for (int ycoor = 0; ycoor < this.yres; ++ycoor) {
                for (int xcoor = 0; xcoor < this.xres; ++xcoor) {
                    temp1 = false;
                    tGrayV = this.RGBtoGrayValue(this.original[ycoor][xcoor]);
                    if (xcoor - 1 >= 0 && (tGrayV - (tGrayL = this.RGBtoGrayValue(this.original[ycoor][xcoor - 1])) > (double)this.EdgeThreshold || tGrayL - tGrayV > (double)this.EdgeThreshold)) {
                        temp1 = true;
                        ++this.n_edges;
                    }
                    if (xcoor + 1 < this.xres && !temp1 && (tGrayV - (tGrayR = this.RGBtoGrayValue(this.original[ycoor][xcoor + 1])) > (double)this.EdgeThreshold || tGrayR - tGrayV > (double)this.EdgeThreshold)) {
                        temp1 = true;
                        ++this.n_edges;
                    }
                    if (ycoor + 1 < this.yres && !temp1 && (tGrayV - (tGrayB = this.RGBtoGrayValue(this.original[ycoor + 1][xcoor])) > (double)this.EdgeThreshold || tGrayB - tGrayV > (double)this.EdgeThreshold)) {
                        temp1 = true;
                        ++this.n_edges;
                    }
                    if (ycoor - 1 < 0 || temp1 || !(tGrayV - (tGrayT = this.RGBtoGrayValue(this.original[ycoor - 1][xcoor])) > (double)this.EdgeThreshold) && !(tGrayT - tGrayV > (double)this.EdgeThreshold)) continue;
                    temp1 = true;
                    ++this.n_edges;
                }
            }
        }
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 32; ++y) {
                this.my_hist[x][y] = 0;
            }
        }
        for (x = 0; x < this.xres; ++x) {
            for (y = 0; y < this.yres; ++y) {
                int tempR = this.original[y][x].getRed();
                tempR /= 8;
                int tempG = this.original[y][x].getGreen();
                tempG /= 8;
                int tempB = this.original[y][x].getBlue();
                tempB /= 8;
                int[] nArray = this.my_hist[0];
                int n = tempR;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.my_hist[1];
                int n2 = tempG;
                nArray2[n2] = nArray2[n2] + 1;
                int[] nArray3 = this.my_hist[2];
                int n3 = tempB;
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
    }

    public void makeHist() {
        int y;
        int x;
        this.my_hist = new int[3][8];
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 8; ++y) {
                this.my_hist[x][y] = 0;
            }
        }
        for (x = 0; x < this.xres; ++x) {
            for (y = 0; y < this.yres; ++y) {
                int tempR = this.original[y][x].getRed();
                tempR /= 32;
                int tempG = this.original[y][x].getGreen();
                tempG /= 32;
                int tempB = this.original[y][x].getBlue();
                tempB /= 32;
                int[] nArray = this.my_hist[0];
                int n = tempR;
                nArray[n] = nArray[n] + 1;
                int[] nArray2 = this.my_hist[1];
                int n2 = tempG;
                nArray2[n2] = nArray2[n2] + 1;
                int[] nArray3 = this.my_hist[2];
                int n3 = tempB;
                nArray3[n3] = nArray3[n3] + 1;
            }
        }
    }

    public double retHistValue(int color, int bin) {
        double rtValue = this.my_hist[color][bin] * 100 / (this.xres * this.yres);
        return rtValue;
    }

    public int retNEdges() {
        return this.n_edges * 100 / (this.xres * this.yres);
    }

    private double RGBtoGrayValue(Color aPixel) {
        double grayValue = aPixel.getRed() + aPixel.getGreen() + aPixel.getBlue();
        return grayValue /= 3.0;
    }

    public void ProcessEdge() {
        boolean temp1 = false;
        double tGrayV = 0.0;
        double tGrayL = 0.0;
        double tGrayR = 0.0;
        double tGrayT = 0.0;
        double tGrayB = 0.0;
        this.n_edges = 0;
        this.my_edge = new Color[this.yres][this.xres];
        System.out.println("Starting Edge Processing...\n");
        for (int ycoor = 0; ycoor < this.yres; ++ycoor) {
            for (int xcoor = 0; xcoor < this.xres; ++xcoor) {
                temp1 = false;
                tGrayV = this.RGBtoGrayValue(this.original[ycoor][xcoor]);
                if (xcoor - 1 >= 0 && (tGrayV - (tGrayL = this.RGBtoGrayValue(this.original[ycoor][xcoor - 1])) > (double)this.EdgeThreshold || tGrayL - tGrayV > (double)this.EdgeThreshold)) {
                    temp1 = true;
                    this.my_edge[ycoor][xcoor] = new Color(0, 0, 0);
                    ++this.n_edges;
                }
                if (xcoor + 1 < this.xres && !temp1 && (tGrayV - (tGrayR = this.RGBtoGrayValue(this.original[ycoor][xcoor + 1])) > (double)this.EdgeThreshold || tGrayR - tGrayV > (double)this.EdgeThreshold)) {
                    temp1 = true;
                    this.my_edge[ycoor][xcoor] = new Color(0, 0, 0);
                    ++this.n_edges;
                }
                if (ycoor + 1 < this.yres && !temp1 && (tGrayV - (tGrayB = this.RGBtoGrayValue(this.original[ycoor + 1][xcoor])) > (double)this.EdgeThreshold || tGrayB - tGrayV > (double)this.EdgeThreshold)) {
                    temp1 = true;
                    this.my_edge[ycoor][xcoor] = new Color(0, 0, 0);
                    ++this.n_edges;
                }
                if (ycoor - 1 >= 0 && !temp1 && (tGrayV - (tGrayT = this.RGBtoGrayValue(this.original[ycoor - 1][xcoor])) > (double)this.EdgeThreshold || tGrayT - tGrayV > (double)this.EdgeThreshold)) {
                    temp1 = true;
                    this.my_edge[ycoor][xcoor] = new Color(0, 0, 0);
                    ++this.n_edges;
                }
                if (temp1) continue;
                this.my_edge[ycoor][xcoor] = new Color(255, 255, 255);
            }
        }
        System.out.println("Process Edge Completed\n\n");
    }

    public void ScaleImage() {
        if (this.yres > 300 && this.xres > 400) {
            boolean nx = false;
            boolean ny = false;
            Color[][] tempImage = null;
            tempImage = new Color[this.yres / 2][this.xres / 2];
            for (int y = 0; y < this.yres - 1; y += 2) {
                for (int x = 0; x < this.xres - 1; x += 2) {
                    nx = false;
                    int avgR = 0;
                    int avgG = 0;
                    int avgB = 0;
                    if (y + 1 < this.yres) {
                        if (x + 1 < this.xres) {
                            avgR = this.original[y][x].getRed() + this.original[y + 1][x].getRed() + this.original[y][x + 1].getRed() + this.original[y + 1][x + 1].getRed();
                            avgR /= 4;
                            avgG = this.original[y][x].getGreen() + this.original[y + 1][x].getGreen() + this.original[y][x + 1].getGreen() + this.original[y + 1][x + 1].getGreen();
                            avgG /= 4;
                            avgB = this.original[y][x].getBlue() + this.original[y + 1][x].getBlue() + this.original[y][x + 1].getBlue() + this.original[y + 1][x + 1].getBlue();
                            avgB /= 4;
                        } else {
                            avgR = this.original[y][x].getRed() + this.original[y + 1][x].getRed();
                            avgG = this.original[y][x].getGreen() + this.original[y + 1][x].getGreen();
                            avgG /= 2;
                            avgB = this.original[y][x].getBlue() + this.original[y + 1][x].getBlue();
                            avgB = (avgR /= 2) / 2;
                        }
                    } else if (x + 1 < this.xres) {
                        avgR = this.original[y][x].getRed() + this.original[y][x + 1].getRed();
                        avgR /= 2;
                        avgG = this.original[y][x].getGreen() + this.original[y][x + 1].getGreen();
                        avgG /= 2;
                        avgB = this.original[y][x].getBlue() + this.original[y][x + 1].getBlue();
                        avgB /= 2;
                    } else {
                        avgR = this.original[y][x].getRed();
                        avgG = this.original[y][x].getGreen();
                        avgB = this.original[y][x].getBlue();
                    }
                    tempImage[y / 2][x / 2] = new Color(avgR, avgG, avgB);
                }
            }
            this.xres /= 2;
            this.yres /= 2;
            this.original = tempImage;
        }
    }
}

