
package project1;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JOptionPane;


public class MainJFrame extends javax.swing.JFrame 
{
    
    /** Creates new form NewJFrame - NewJFrame constructor */
    public MainJFrame() {
        initComponents();        
        jFileChooser1 = new javax.swing.JFileChooser();       
            
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        jFileChooser1 = new javax.swing.JFileChooser();
        AboutPane = new javax.swing.JOptionPane();
        ExitPane = new javax.swing.JOptionPane();
        MenuBar = new javax.swing.JMenuBar();
        File = new javax.swing.JMenu();
        FileOpen = new javax.swing.JMenuItem();
        FileSave = new javax.swing.JMenuItem();
        FileExit = new javax.swing.JMenuItem();
        Process = new javax.swing.JMenu();
        Process_Edge = new javax.swing.JMenuItem();
        Process_Sim = new javax.swing.JMenuItem();
        Process_Intelligent = new javax.swing.JMenuItem();
        Process_Orig = new javax.swing.JMenuItem();
        Help = new javax.swing.JMenu();
        About = new javax.swing.JMenuItem();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        File.setText("File");
        FileOpen.setText("Open");
        FileOpen.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FileOpenActionPerformed(evt);
            }
        });

        File.add(FileOpen);

        FileSave.setText("Save");
        FileSave.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FileSaveActionPerformed(evt);
            }
        });

        File.add(FileSave);

        FileExit.setText("Exit");
        FileExit.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                FileExitActionPerformed(evt);
            }
        });

        File.add(FileExit);

        MenuBar.add(File);

        Process.setText("Process");
        Process_Edge.setText("Edge");
        Process_Edge.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ProcessEdgeActionPerformed(evt);
            }
        });

        Process.add(Process_Edge);

        Process_Sim.setText("Simple Analysis");
        Process_Sim.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ProcessSimpleActionPreformed(evt);
            }
        });

        Process.add(Process_Sim);

        Process_Intelligent.setText("Intelligent Analysis");
        Process_Intelligent.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ProcessIntelligentActionPreformed(evt);
            }
        });

        Process.add(Process_Intelligent);

        Process_Orig.setText("Original");
        Process_Orig.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                ProcessOriginalActionPreformed(evt);
            }
        });

        Process.add(Process_Orig);

        MenuBar.add(Process);

        Help.setText("Help");
        About.setText("About");
        About.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                HelpAboutActionPreformed(evt);
            }
        });

        Help.add(About);

        MenuBar.add(Help);

        setJMenuBar(MenuBar);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 400, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 279, Short.MAX_VALUE)
        );
        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void HelpAboutActionPreformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_HelpAboutActionPreformed
        AboutPane = new JOptionPane();
        AboutPane.showMessageDialog(this,"Questions? Contact Nik: http://www.stat.purdue.edu/~ntuzov/");
    }//GEN-LAST:event_HelpAboutActionPreformed

    private void ProcessIntelligentActionPreformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ProcessIntelligentActionPreformed
        int tindex;
        String dirPath;
        String [] tempV;
        top3Images = new MyImage [3];
        double [] top3Values = new double [3];
        double Sum,SumE;
        double tS,tSe;
        double Smult=1.75,Emult=0.5;
        MyImage tempImage;
        if(jimg != null)
        {
            jimg.makeIntelligent();
            top3Values[0]=99999;
            top3Values[1]=99999;
            top3Values[2]=99999;
            top3Images[0]=null;
            top3Images[1]=null;
            top3Images[2]=null;
            dirPath = input_file.getPath();
            tindex = dirPath.lastIndexOf("/");
            dirPath = dirPath.substring(0,tindex+1);
            File T_file = new File(dirPath);
            tempV = T_file.list();
            for(String sFile : tempV)
            {
                if(sFile.endsWith(".rgb") == true)
                {
                    if(sFile.compareTo(input_file.getName()) != 0)
                    {
                        tempImage = new MyImage(dirPath+sFile);
                        tempImage.makeIntelligent();
                        Sum = 0;
                        SumE = 0;
                        tSe = 0;
                        tS = 0;
                        for(int x=0; x<32; x++) //YOU NEED TO CHANGE THIS WITH CHANGES IN BINS
                        {
                            tS = Math.pow(jimg.retHistValue(0,x)-tempImage.retHistValue(0,x),2);
                            tS += Math.pow(jimg.retHistValue(1,x)-tempImage.retHistValue(1,x),2);
                            tS += Math.pow(jimg.retHistValue(2,x)-tempImage.retHistValue(2,x),2);
                            Sum += Math.sqrt(tS);
                        }
                        SumE = Math.abs(jimg.retNEdges()-tempImage.retNEdges());
                        if((Smult*Sum+Emult*SumE) < top3Values[0])
                        {
                            top3Values[2]=top3Values[1];
                            top3Images[2]=top3Images[1];
                            top3Values[1]=top3Values[0];
                            top3Images[1]=top3Images[0];
                            top3Values[0]=Smult*Sum+Emult*SumE;
                            top3Images[0] = tempImage;                            
                        }
                        else if((Smult*Sum+Emult*SumE) < top3Values[1])
                        {
                            top3Values[2]=top3Values[1];
                            top3Images[2]=top3Images[1];
                            top3Values[1]=Smult*Sum+Emult*SumE;
                            top3Images[1] = tempImage;
                        }
                        else if((Smult*Sum+Emult*SumE) < top3Values[2])
                        {
                            top3Values[2]=Smult*Sum+Emult*SumE;
                            top3Images[2] = tempImage;
                        }
                    }
                }
            }
            System.out.println(top3Values[0]+" "+top3Values[1]+" "+top3Values[2]+"\n");
            jimg.ScaleImage();
            jimg.turnOnImagePrint();
            MyJPanel1.getParent().remove(MyJPanel1);
            if(MyJPanel2 != null)
            {
                MyJPanel2.getParent().remove(MyJPanel2);
            }
            if(MyJPanel3 != null)
            {
                MyJPanel3.getParent().remove(MyJPanel3);
            }
            if(MyJPanel4 != null)
            {
                MyJPanel4.getParent().remove(MyJPanel4);
            }
            MyJPanel1 = new MyPanel(jimg);
            MyJPanel1.SetNumber(1);
            setLayout(new GridLayout(2, 2));
            getContentPane().add(MyJPanel1);
            if(top3Images[0] != null)
            {
                top3Images[0].ScaleImage();
                MyJPanel2 = new MyPanel(top3Images[0]);
                MyJPanel2.SetNumber(2);
                getContentPane().add(MyJPanel2);
            }
            if(top3Images[1] != null)
            {
                top3Images[1].ScaleImage();
                MyJPanel3 = new MyPanel(top3Images[1]);
                MyJPanel3.SetNumber(3);
                getContentPane().add(MyJPanel3);
            }
            if(top3Images[2] != null)
            {
                top3Images[2].ScaleImage();
                MyJPanel4 = new MyPanel(top3Images[2]);
                MyJPanel4.SetNumber(4);
                getContentPane().add(MyJPanel4);
            }
            this.setPreferredSize(new Dimension(815,650));
            pack();
            MyJPanel1.repaint();
            if(MyJPanel2 != null)
            {
                MyJPanel2.repaint();
            }
            if(MyJPanel3 != null)
            {
                MyJPanel3.repaint();
            }
            if(MyJPanel4 != null)
            {
                MyJPanel3.repaint();
            }
        }
    }//GEN-LAST:event_ProcessIntelligentActionPreformed

    private void ProcessSimpleActionPreformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ProcessSimpleActionPreformed
        //start the basic histogram analysis
        //opening all the files......hmm.
        int tindex;
        String dirPath;
        String [] tempV;
        top3Images = new MyImage [3];
        double [] top3Values = new double [3];
        double Sum;
        double tS;
        if(jimg != null)
        {
            jimg.makeHist();
            top3Values[0]=99999;
            top3Values[1]=99999;
            top3Values[2]=99999;
            dirPath = input_file.getPath();
            tindex = dirPath.lastIndexOf("/");
            dirPath = dirPath.substring(0,tindex+1);
            File T_file = new File(dirPath);
            tempV = T_file.list();
            for(String sFile : tempV)
            {
                if(sFile.endsWith(".rgb") == true)
                {
                    if(sFile.compareTo(input_file.getName()) != 0)
                    {
                        MyImage tempImage = new MyImage(dirPath+sFile);
                        tempImage.makeHist();
                        Sum = 0;
                        tS = 0;
                        for(int x=0; x<8; x++)
                        {
                            tS = Math.pow(jimg.retHistValue(0,x)-tempImage.retHistValue(0,x),2);
                            tS += Math.pow(jimg.retHistValue(1,x)-tempImage.retHistValue(1,x),2);
                            tS += Math.pow(jimg.retHistValue(2,x)-tempImage.retHistValue(2,x),2);
                            Sum += Math.sqrt(tS);
                        }
                        if(Sum < top3Values[0])
                        {
                            top3Values[2]=top3Values[1];
                            top3Images[2]=top3Images[1];
                            top3Values[1]=top3Values[0];
                            top3Images[1]=top3Images[0];
                            top3Values[0]=Sum;
                            top3Images[0] = tempImage;                            
                        }
                        else if(Sum < top3Values[1])
                        {
                            top3Values[2]=top3Values[1];
                            top3Images[2]=top3Images[1];
                            top3Values[1]=Sum;
                            top3Images[1] = tempImage;
                        }
                        else if(Sum < top3Values[2])
                        {
                            top3Values[2]=Sum;
                            top3Images[2] = tempImage;
                        }
                    }
                }
            }
                        
            // to display multiple images in the frame
            
            jimg.turnOnImagePrint();
            MyJPanel1.getParent().remove(MyJPanel1);
            if(MyJPanel2 != null)
            {
                MyJPanel2.getParent().remove(MyJPanel2);
            }
            if(MyJPanel3 != null)
            {
                MyJPanel3.getParent().remove(MyJPanel3);
            }
            if(MyJPanel4 != null)
            {
                MyJPanel4.getParent().remove(MyJPanel4);
            }
            jimg.ScaleImage();
            MyJPanel1 = new MyPanel(jimg);
            MyJPanel1.SetNumber(1);
            setLayout(new GridLayout(2, 2));
            getContentPane().add(MyJPanel1);
            if(top3Images[0] != null)
            {
                top3Images[0].ScaleImage();
                MyJPanel2 = new MyPanel(top3Images[0]);
                MyJPanel2.SetNumber(2);
                getContentPane().add(MyJPanel2);
            }
            if(top3Images[1] != null)
            {
                top3Images[1].ScaleImage();
                MyJPanel3 = new MyPanel(top3Images[1]);
                MyJPanel3.SetNumber(3);
                getContentPane().add(MyJPanel3);
            }
            if(top3Images[2] != null)
            {
                top3Images[2].ScaleImage();
                MyJPanel4 = new MyPanel(top3Images[2]);
                MyJPanel4.SetNumber(4);
                getContentPane().add(MyJPanel4);
            }
            this.setPreferredSize(new Dimension(815,650));
            pack();
            MyJPanel1.repaint();
            if(MyJPanel2 != null)
            {
                MyJPanel2.repaint();
            }
            if(MyJPanel3 != null)
            {
                MyJPanel3.repaint();
            }
            if(MyJPanel4 != null)
            {
                MyJPanel3.repaint();
            }
        }
        else
        {
            System.out.println("Open an Image first!\n");
        }
    }//GEN-LAST:event_ProcessSimpleActionPreformed

    private void ProcessOriginalActionPreformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ProcessOriginalActionPreformed
        if(jimg != null)
        {
            jimg.turnOnImagePrint();
            MyJPanel1.repaint();
        }
    }//GEN-LAST:event_ProcessOriginalActionPreformed

    private void ProcessEdgeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_ProcessEdgeActionPerformed
        if (jimg != null)
        {
            System.out.println("Calling Edge Process...\n");
            jimg.ProcessEdge();
            jimg.turnOnEdgePrint();
            MyJPanel1.repaint();
        }
        else
        {
            System.out.println("Image is null can't edge process\n");
        }
    }//GEN-LAST:event_ProcessEdgeActionPerformed

    private void FileExitActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FileExitActionPerformed
        ExitPane = new JOptionPane();
        String [] tempStr = new String [2];
        tempStr[0] = "Yes";
        tempStr[1] = "No";
        int n = ExitPane.showOptionDialog(this,"Are you sure you want to quit?","Exit",JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE,null,tempStr,"No");
        if(n == 0)
        {
            System.exit(0);
        }
    }//GEN-LAST:event_FileExitActionPerformed

    private void FileSaveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FileSaveActionPerformed
        if(jimg != null && MyJPanel1 != null && jimg.n_edges != 0)
        {         
            File fileName = null;
            String newName = new String();
            newName = input_file.getPath();
            int n = newName.lastIndexOf(".rgb");
            newName = newName.substring(0,n);
            newName = newName + "e.rgb";
            fileName = new File(newName);
            try {
                DataOutputStream edgefile = new DataOutputStream(new FileOutputStream(fileName));
                
                edgefile.write(jimg.yres&0xFF);
                edgefile.write((jimg.yres>>8)&0xFF);
                edgefile.write(jimg.xres&0xFF);
                edgefile.write((jimg.xres>>8)&0xFF);
                for(int y=0; y<jimg.yres; y++)
                {
                    for(int x=0; x<jimg.xres; x++)
                    {
                        edgefile.writeByte(jimg.my_edge[y][x].getRed());
                        edgefile.writeByte(jimg.my_edge[y][x].getGreen());
                        edgefile.writeByte(jimg.my_edge[y][x].getBlue());
                    }
                }
                edgefile.close();
                
            } catch (IOException exp) {
                System.out.println("Failed On save because of exception");
            }
        }
    }//GEN-LAST:event_FileSaveActionPerformed

    private void FileOpenActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_FileOpenActionPerformed
      // TODO add your handling code here:
        
    jFileChooser1.setFileFilter(new RgbFilter());    
    int returnVal = jFileChooser1.showOpenDialog(this);
    if (returnVal == javax.swing.JFileChooser.APPROVE_OPTION) {
        input_file = jFileChooser1.getSelectedFile();
        
          
        jimg = new MyImage(input_file.getPath());
        jimg.printEdge = 0;    
        
        // It makes sense to create MyJPanel1 only after a file is chosen
        if(MyJPanel1 != null)
        {
            MyJPanel1.getParent().remove(MyJPanel1);
        }
        if(MyJPanel2 != null)
        {
            MyJPanel2.getParent().remove(MyJPanel2);
        }
        if(MyJPanel3 != null)
        {
            MyJPanel3.getParent().remove(MyJPanel3);
        }
        if(MyJPanel4 != null)
        {
            MyJPanel4.getParent().remove(MyJPanel4);
        }
        MyJPanel2 = null;
        MyJPanel3 = null;
        MyJPanel4 = null;
        setLayout(new GridLayout(1,1));
        MyJPanel1 = new MyPanel(jimg); // This creates an instance of MyPanel whose
                                       // size is slightly larger than jimg, but it doesn't show the image itself 
        this.setPreferredSize(new Dimension(jimg.xres+15,jimg.yres+50));
        getContentPane().add(MyJPanel1);
        pack();
        
        // SOUTH means that MyJPanel1 is placed at the bottom of NewJFrame
        // so when you want to display four images in the corners of NewJFrame,
        // you have to use that parameter
              
        MyJPanel1.repaint();        
        
     }        
        
    }//GEN-LAST:event_FileOpenActionPerformed
    
  
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new MainJFrame().setVisible(true);
            }
        });
    }
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JMenuItem About;
    private javax.swing.JOptionPane AboutPane;
    private javax.swing.JOptionPane ExitPane;
    private javax.swing.JMenu File;
    private javax.swing.JMenuItem FileExit;
    private javax.swing.JMenuItem FileOpen;
    private javax.swing.JMenuItem FileSave;
    private javax.swing.JMenu Help;
    private javax.swing.JMenuBar MenuBar;
    private javax.swing.JMenu Process;
    private javax.swing.JMenuItem Process_Edge;
    private javax.swing.JMenuItem Process_Intelligent;
    private javax.swing.JMenuItem Process_Orig;
    private javax.swing.JMenuItem Process_Sim;
    private javax.swing.JFileChooser jFileChooser1;
    // End of variables declaration//GEN-END:variables
     
    // both of these are now members of NewJFrame that get initialized when FileOpen is chosen
    private MyPanel MyJPanel1 = null; 
    private MyPanel MyJPanel2 = null;
    private MyPanel MyJPanel3 = null;
    private MyPanel MyJPanel4 = null;
    MyImage jimg = null;
    MyImage [] top3Images;
    File input_file = null;
    
}  

