
package project1;

import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;

public class MyImage {
    
    public Color [][] original;
    public Color [][] my_edge;
    public int [][] my_hist;
    public int n_edges;
    public int xres;
    public int yres;
    public int printEdge=0;
    int EdgeThreshold = 18;
    
    /** Creates a new instance of MyImage */
    public MyImage(String fileName) {
        
          try {
            DataInputStream imgfile = new DataInputStream(new FileInputStream(fileName));            
                 
            byte [] yindata = new byte[2];
            imgfile.read(yindata);
            
            if (yindata[0] < 0) {
                yres = yindata[0] + 256 + 256 * yindata[1]; // height
            } else {
                yres = yindata[0] + 256 * yindata[1];
            }
            
            byte [] xindata = new byte[2];
            imgfile.read(xindata);
            
            if (xindata[0] < 0) {
                xres = xindata[0] + 256 + 256 * xindata[1];  // width
            } else {
                xres = xindata[0] + 256 * xindata[1];
            }
            
            if ((xres < 0) || (yres < 0)) {
               return;
            }
            
            original = new Color[yres][xres];
            
            for (int ycoor = 0; ycoor < yres; ycoor++) {
                for (int xcoor = 0; xcoor < xres; xcoor++) {
                    original[ycoor][xcoor] = new Color(imgfile.readUnsignedByte(), imgfile.readUnsignedByte(), imgfile.readUnsignedByte());
                }
            }
            imgfile.close();
            
        } catch (IOException exp) {
            System.out.println("IO error");
        }
        n_edges = 0;
                   
    }

    public void drawImage(Graphics gfx){
          
        for (int ycoor = 0; ycoor < yres; ycoor++) {
                for (int xcoor = 0; xcoor < xres; xcoor++) {
                    if(printEdge == 0)
                    {
                        gfx.setColor(original[ycoor][xcoor]);
                    }
                    else
                    {
                        gfx.setColor(my_edge[ycoor][xcoor]);
                    }
                    gfx.fillRect(xcoor, ycoor, 1, 1);
                } 
       }
       
    } // drawImage ends
    
    public void turnOnEdgePrint()
    {
        printEdge = 1;
    }
    
    public void turnOnImagePrint()
    {
        printEdge = 0;
    }
    
    public void makeIntelligent()
    /*
    * This is the "intelligent" picture analysis. Its going to be a better ColorHist
    * with more bins and an edge histogram.
    */
    {
        int x,y;
        int nBins = 32;
        int tempR,tempG,tempB;
        my_hist = new int [3][32];
        if(n_edges == 0)
        {
            int temp1=0;
            double tGrayV = 0;
            double tGrayL = 0;
            double tGrayR = 0;
            double tGrayT = 0;
            double tGrayB = 0;

            n_edges = 0;

            System.out.println("Starting Edge Processing...\n");
            for (int ycoor = 0; ycoor < yres; ycoor++) {
                    for (int xcoor = 0; xcoor < xres; xcoor++) {

                    temp1 = 0;
                    tGrayV = RGBtoGrayValue(original[ycoor][xcoor]);
                    if(xcoor-1 >= 0) //check the left pixel
                    {
                        tGrayL = RGBtoGrayValue(original[ycoor][xcoor-1]);
                        if((tGrayV - tGrayL > EdgeThreshold) || (tGrayL - tGrayV > EdgeThreshold))
                        {
                            //Found an Edge.                           
                            temp1 = 1;
                            n_edges++;
                        }
                    }

                    if((xcoor+1 < xres) && (temp1 == 0)) //check the right pixel
                    {
                        tGrayR = RGBtoGrayValue(original[ycoor][xcoor+1]);
                        if((tGrayV - tGrayR > EdgeThreshold) || (tGrayR - tGrayV > EdgeThreshold))
                        {
                            //Found an Edge.                            
                            temp1 = 1;
                            n_edges++;
                        }
                    }

                    if((ycoor+1 < yres) && (temp1 != 1)) //check the bottom pixel
                    {
                        tGrayB = RGBtoGrayValue(original[ycoor+1][xcoor]);
                        if((tGrayV - tGrayB > EdgeThreshold) || (tGrayB - tGrayV > EdgeThreshold))
                        {
                            //Found an Edge.
                            temp1 = 1;
                            n_edges++;
                        }
                    }

                    if((ycoor-1 >= 0) && (temp1 != 1)) //check the top pixel
                    {
                        tGrayT = RGBtoGrayValue(original[ycoor-1][xcoor]);
                        if((tGrayV - tGrayT > EdgeThreshold) || (tGrayT - tGrayV > EdgeThreshold))
                        {
                            //Found an Edge.
                            temp1 = 1;
                            n_edges++;
                        }
                    }
                }
            }
        }
        
        for(x=0; x<3; x++)
        {
            for(y=0; y<32; y++)
            {
                my_hist[x][y] = 0;
            }
        }
        
        for(x=0; x<xres; x++)
        {
            for(y=0; y<yres; y++)
            {
                tempR = original[y][x].getRed();
                tempR = tempR / 8;
                
                tempG = original[y][x].getGreen();
                tempG = tempG / 8;
                
                tempB = original[y][x].getBlue();
                tempB = tempB / 8;
                
                my_hist[0][tempR]++;
                my_hist[1][tempG]++;
                my_hist[2][tempB]++;
            }
        }
    } 
	
    public void makeHist()
   /*
    * creates the histogram for the picture.
    */
    
    {
        int x,y;
        int tempR,tempG,tempB;
        my_hist = new int [3][8];
        for(x=0; x<3; x++)
        {
            for(y=0; y<8; y++)
            {
                my_hist[x][y] = 0;
            }
        }
        
        for(x=0; x<xres; x++)
        {
            for(y=0; y<yres; y++)
            {
                tempR = original[y][x].getRed();
                tempR = tempR / 32;
                
                tempG = original[y][x].getGreen();
                tempG = tempG / 32;
                
                tempB = original[y][x].getBlue();
                tempB = tempB / 32;
                
                my_hist[0][tempR]++;
                my_hist[1][tempG]++;
                my_hist[2][tempB]++;
            }
        }
    } //end makeHist
	
    public double retHistValue(int color, int bin)
    /*
    * Returns a normalized histogram value to calculate the euclidean distance
    */
    {
            double rtValue;
            rtValue = (my_hist[color][bin] * 100) / (xres * yres);
            return rtValue;
    } //end retHistValue
    
    public int retNEdges()
    /*
     *  Returns the number of edges.
     */
    {
        return (n_edges * 100) / (xres * yres);
    }

    private double RGBtoGrayValue(Color aPixel)
    /*
    * Converts a colored pixel to the cooresponding gray value and returns it.
    */
    {
        double grayValue;
        grayValue = aPixel.getRed() + aPixel.getGreen() + aPixel.getBlue();
        grayValue = grayValue / 3;
        return grayValue;
    } //end RGBtoGrayValue
	
    public void ProcessEdge()
    /*
    * Does the edge processing on the image. It simply takes each pixel and checks the gray value of the neighboring pixels
    * if there is a difference that surpases the threshold then it will make the cooresponding pixel black. otherwise it will be white.
    */
    {
        int temp1=0;
        double tGrayV = 0;
        double tGrayL = 0;
        double tGrayR = 0;
        double tGrayT = 0;
        double tGrayB = 0;
        
        n_edges = 0;
	my_edge = new Color[yres][xres];
        
        System.out.println("Starting Edge Processing...\n");
       for (int ycoor = 0; ycoor < yres; ycoor++) {
                for (int xcoor = 0; xcoor < xres; xcoor++) {
                    
                temp1 = 0;
                tGrayV = RGBtoGrayValue(original[ycoor][xcoor]);
                if(xcoor-1 >= 0) //check the left pixel
                {
                    tGrayL = RGBtoGrayValue(original[ycoor][xcoor-1]);
                    if((tGrayV - tGrayL > EdgeThreshold) || (tGrayL - tGrayV > EdgeThreshold))
                    {
                        //Found an Edge.
                        temp1 = 1;
                        my_edge[ycoor][xcoor] = new Color(0,0,0);
                        n_edges++;
                    }
                }
                
                if((xcoor+1 < xres) && (temp1 == 0)) //check the right pixel
                {
                    tGrayR = RGBtoGrayValue(original[ycoor][xcoor+1]);
                    if((tGrayV - tGrayR > EdgeThreshold) || (tGrayR - tGrayV > EdgeThreshold))
                    {
                        //Found an Edge.
                        temp1 = 1;
                        my_edge[ycoor][xcoor] = new Color(0,0,0);
                        n_edges++;
                    }
                }
                
		if((ycoor+1 < yres) && (temp1 != 1)) //check the bottom pixel
                {
                    tGrayB = RGBtoGrayValue(original[ycoor+1][xcoor]);
                    if((tGrayV - tGrayB > EdgeThreshold) || (tGrayB - tGrayV > EdgeThreshold))
                    {
                        //Found an Edge.
                        temp1 = 1;
                        my_edge[ycoor][xcoor] = new Color(0,0,0);
                        n_edges++;
                    }
                }
                
		if((ycoor-1 >= 0) && (temp1 != 1)) //check the top pixel
                {
                    tGrayT = RGBtoGrayValue(original[ycoor-1][xcoor]);
                    if((tGrayV - tGrayT > EdgeThreshold) || (tGrayT - tGrayV > EdgeThreshold))
                    {
                        //Found an Edge.
                        temp1 = 1;
                        my_edge[ycoor][xcoor] = new Color(0,0,0);
                        n_edges++;
                    }
                }
                
                if (temp1 != 1) //if no edge...then its a white spot!
                {
                    my_edge[ycoor][xcoor] = new Color(255,255,255);
                }
            }
        }
        System.out.println("Process Edge Completed\n\n");
    } //end ProcessEdge 
    
    public void ScaleImage()
    {
        if(yres > 300 && xres > 400)
        {
            int avgR,avgG,avgB,nx=0,ny=0;
            Color [][] tempImage = null;
            tempImage = new Color [yres/2][xres/2];
            for(int y=0;y<(yres-1);y=y+2)
            {
                for(int x=0;x<(xres-1);x=x+2)
                {
                    nx = 0;
                    avgR = 0;
                    avgG = 0;
                    avgB = 0;
                    if(y+1 < yres)
                    {
                        if(x+1 < xres)
                        {
                            avgR = original[y][x].getRed() + original[y+1][x].getRed() + original[y][x+1].getRed() + original[y+1][x+1].getRed();
                            avgR = avgR / 4;
                            avgG = original[y][x].getGreen() + original[y+1][x].getGreen() + original[y][x+1].getGreen() + original[y+1][x+1].getGreen();
                            avgG = avgG / 4;
                            avgB = original[y][x].getBlue() + original[y+1][x].getBlue() + original[y][x+1].getBlue() + original[y+1][x+1].getBlue();
                            avgB = avgB / 4;
                            
                        }
                        else
                        {
                            avgR = original[y][x].getRed() + original[y+1][x].getRed();
                            avgR = avgR / 2;
                            avgG = original[y][x].getGreen() + original[y+1][x].getGreen();
                            avgG = avgG / 2;
                            avgB = original[y][x].getBlue() + original[y+1][x].getBlue();
                            avgB = avgR / 2;
                        }
                    }
                    else
                    {
                        if(x+1 < xres)
                        {
                            avgR = original[y][x].getRed() + original[y][x+1].getRed();
                            avgR = avgR / 2;
                            avgG = original[y][x].getGreen() + original[y][x+1].getGreen();
                            avgG = avgG / 2;
                            avgB = original[y][x].getBlue() + original[y][x+1].getBlue();
                            avgB = avgB / 2;
                        }
                        else
                        {
                            avgR = original[y][x].getRed();
                            avgG = original[y][x].getGreen();
                            avgB = original[y][x].getBlue();
                        }
                    }
                    tempImage[y/2][x/2] = new Color(avgR,avgG,avgB);
                }
            }
            xres = xres/2;
            yres = yres/2;
            original = tempImage;
        }
    }
} // MyImage ends

 