/*
 * Decompiled with CFR 0.152.
 */
package MyProj3;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class CustomImage {
    private int ci_xres = 0;
    private int ci_yres = 0;
    private Color[][] ci_image = null;
    private int ci_lambda = 0;

    public void loadImage(String fileName) {
        try {
            DataInputStream imgfile = new DataInputStream(new FileInputStream(fileName));
            byte[] yindata = new byte[2];
            imgfile.read(yindata);
            this.ci_yres = yindata[0] < 0 ? yindata[0] + 256 + 256 * yindata[1] : yindata[0] + 256 * yindata[1];
            byte[] xindata = new byte[2];
            imgfile.read(xindata);
            this.ci_xres = xindata[0] < 0 ? xindata[0] + 256 + 256 * xindata[1] : xindata[0] + 256 * xindata[1];
            if (this.ci_xres < 0 || this.ci_yres < 0) {
                return;
            }
            this.ci_image = new Color[this.ci_yres][this.ci_xres];
            for (int ycoor = 0; ycoor < this.ci_yres; ++ycoor) {
                for (int xcoor = 0; xcoor < this.ci_xres; ++xcoor) {
                    this.ci_image[ycoor][xcoor] = new Color(imgfile.readUnsignedByte(), imgfile.readUnsignedByte(), imgfile.readUnsignedByte());
                }
            }
            imgfile.close();
        }
        catch (IOException exp) {
            System.out.println("IO error");
        }
    }

    public void setLambda(int lambda) {
        this.ci_lambda = lambda;
    }

    public void saveFile(String fileName) {
        try {
            DataOutputStream outfile = new DataOutputStream(new FileOutputStream(fileName));
            byte[] youtdata = new byte[2];
            byte[] xoutdata = new byte[2];
            Integer intv = new Integer(this.ci_yres / 256);
            youtdata[1] = intv.byteValue();
            if (this.ci_yres % 256 > 127) {
                intv = new Integer(this.ci_yres % 256 - 256);
                youtdata[0] = intv.byteValue();
            } else {
                intv = new Integer(this.ci_yres % 256);
                youtdata[0] = intv.byteValue();
            }
            outfile.write(youtdata);
            intv = new Integer(this.ci_xres / 256);
            xoutdata[1] = intv.byteValue();
            if (this.ci_xres % 256 > 127) {
                intv = new Integer(this.ci_xres % 256 - 256);
                xoutdata[0] = intv.byteValue();
            } else {
                intv = new Integer(this.ci_xres % 256);
                xoutdata[0] = intv.byteValue();
            }
            outfile.write(xoutdata);
            for (int ycoor = 0; ycoor < this.ci_yres; ++ycoor) {
                for (int xcoor = 0; xcoor < this.ci_xres; ++xcoor) {
                    outfile.writeByte(this.ci_image[ycoor][xcoor].getRed());
                    outfile.writeByte(this.ci_image[ycoor][xcoor].getGreen());
                    outfile.writeByte(this.ci_image[ycoor][xcoor].getBlue());
                }
            }
            outfile.close();
        }
        catch (IOException exp) {
            System.out.println("IO error");
        }
    }

    public void sharpenImage() {
        int colCnt;
        int rowCnt;
        int pval = 2;
        double sum = 0.0;
        double[][] hmatrix = new double[2 * pval + 1][2 * pval + 1];
        for (rowCnt = 0; rowCnt < 2 * pval + 1; ++rowCnt) {
            for (colCnt = 0; colCnt < 2 * pval + 1; ++colCnt) {
                hmatrix[rowCnt][colCnt] = Math.abs(1.0 - Math.abs((double)(rowCnt - pval) / (double)(pval + 1))) * Math.abs(1.0 - Math.abs((double)(colCnt - pval) / (double)(pval + 1)));
                sum += hmatrix[rowCnt][colCnt];
            }
        }
        for (rowCnt = 0; rowCnt < 2 * pval + 1; ++rowCnt) {
            colCnt = 0;
            while (colCnt < 2 * pval + 1) {
                double[] dArray = hmatrix[rowCnt];
                int n = colCnt++;
                dArray[n] = dArray[n] / sum;
            }
        }
        for (rowCnt = 0; rowCnt < 2 * pval + 1; ++rowCnt) {
            colCnt = 0;
            while (colCnt < 2 * pval + 1) {
                double[] dArray = hmatrix[rowCnt];
                int n = colCnt++;
                dArray[n] = dArray[n] * (double)(-this.ci_lambda);
            }
        }
        double[] dArray = hmatrix[pval];
        int n = pval;
        dArray[n] = dArray[n] + (double)(1 + this.ci_lambda);
        for (int ycoor = pval; ycoor < this.ci_yres - pval; ++ycoor) {
            for (int xcoor = pval; xcoor < this.ci_xres - pval; ++xcoor) {
                int pixelR = 0;
                int pixelG = 0;
                int pixelB = 0;
                for (int m = -pval; m <= pval; ++m) {
                    for (int n2 = -pval; n2 <= pval; ++n2) {
                        pixelR = (int)((double)pixelR + (double)this.ci_image[ycoor - m][xcoor - n2].getRed() * hmatrix[m + pval][n2 + pval]);
                        pixelG = (int)((double)pixelG + (double)this.ci_image[ycoor - m][xcoor - n2].getGreen() * hmatrix[m + pval][n2 + pval]);
                        pixelB = (int)((double)pixelB + (double)this.ci_image[ycoor - m][xcoor - n2].getBlue() * hmatrix[m + pval][n2 + pval]);
                    }
                }
                if (pixelR > 255) {
                    pixelR = 255;
                }
                if (pixelR < 0) {
                    pixelR = 0;
                }
                if (pixelG > 255) {
                    pixelG = 255;
                }
                if (pixelG < 0) {
                    pixelG = 0;
                }
                if (pixelB > 255) {
                    pixelB = 255;
                }
                if (pixelB < 0) {
                    pixelB = 0;
                }
                this.ci_image[ycoor][xcoor] = new Color(pixelR, pixelG, pixelB);
            }
        }
    }
}

