/*
 * Decompiled with CFR 0.152.
 */
package MyProj3;

import MyProj3.CustomImage;
import java.io.File;
import java.util.ArrayList;

public class CustomThread
extends Thread {
    private CustomImage img;
    private ArrayList<File> files = new ArrayList();
    private long pixels = 0L;
    private int id = 0;
    private long loadTime = 0L;
    private long sharpenTime = 0L;
    private long saveTime = 0L;

    public CustomThread() {
        this.img = new CustomImage();
    }

    public CustomThread(int id, int lambda) {
        this();
        this.setLambda(lambda);
        this.id = id;
    }

    public void run() {
        if (this.files.size() <= 0) {
            return;
        }
        for (int i = 0; i < this.files.size(); ++i) {
            long start = System.currentTimeMillis();
            this.img.loadImage(this.files.get(i).getPath());
            this.loadTime += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            this.img.sharpenImage();
            this.sharpenTime += System.currentTimeMillis() - start;
            start = System.currentTimeMillis();
            this.img.saveFile(this.files.get(i).getPath().replace(".rgb", "s.rgb"));
            this.saveTime += System.currentTimeMillis() - start;
        }
    }

    public long getPixels() {
        return this.pixels;
    }

    public void addFile(File file) {
        this.files.add(file);
        this.pixels += (file.length() - 4L) / 3L;
    }

    public void setLambda(int lambda) {
        this.img.setLambda(lambda);
    }

    public void setThreadId(int id) {
        this.id = id;
    }

    public long getLoadTime() {
        return this.loadTime;
    }

    public long getSharpenTime() {
        return this.sharpenTime;
    }

    public long getSaveTime() {
        return this.saveTime;
    }
}

