/*
 * Decompiled with CFR 0.152.
 */
package MyProj3;

import MyProj3.ThreadHandler;

public class MyProj3 {
    public static void main(String[] args) {
        String dir = "";
        int threads = 0;
        int lambda = 0;
        int valid_args = 0;
        long start = System.currentTimeMillis();
        try {
            if (args.length != 3) {
                throw new Exception("Error: the number of arguments is not three. ");
            }
            for (int argcnt = 0; argcnt < args.length; ++argcnt) {
                if (args[argcnt].length() > 5 && args[argcnt].substring(0, 5).equals("-dir=")) {
                    dir = args[argcnt].substring(5);
                    ++valid_args;
                    continue;
                }
                if (args[argcnt].length() > 8 && args[argcnt].substring(0, 8).equals("-lambda=")) {
                    try {
                        lambda = Integer.parseInt(args[argcnt].substring(8));
                        ++valid_args;
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        throw new Exception("Error: converting the value of lambda from String to Int failed. ");
                    }
                }
                if (args[argcnt].length() <= 8 || !args[argcnt].substring(0, 8).equals("-thread=")) continue;
                try {
                    threads = Integer.parseInt(args[argcnt].substring(8));
                    ++valid_args;
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new Exception("Error: converting the value of threads from String to Int failed. ");
                }
            }
            if (valid_args != 3) {
                throw new Exception("Error: the three arguments are not -dir=..., -thread=..., -lambda=... ");
            }
            if (lambda < 0 || lambda > 10) {
                throw new Exception("Error: the value of lambda must be between 0 and 10. ");
            }
            if (threads < 1 || threads > 8) {
                throw new Exception("Error the number of threads should be between 1 and 8. ");
            }
            ThreadHandler th = new ThreadHandler(dir, lambda, threads);
            long pixels = th.BatchProcess();
            long end = System.currentTimeMillis();
            System.out.println("Execution Time: " + (end - start) + " ms");
            System.out.println("Performance: " + (end - start) * 1000L / pixels + " us/pixel");
        }
        catch (Exception e) {
            System.err.println(e.getMessage() + " The program will terminate now.");
        }
    }
}

