/*
 * Decompiled with CFR 0.152.
 */
package MyProj3;

import MyProj3.CustomThread;
import java.io.File;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadHandler {
    private String dir;
    private int lambda;
    private int threads;

    public ThreadHandler(String dir, int lambda, int threads) {
        this.dir = dir;
        this.lambda = lambda;
        this.threads = threads;
    }

    public long BatchProcess() throws Exception {
        int i;
        long bytes = 0L;
        long taskTime = 0L;
        long sharpenTime = 0L;
        long saveTime = 0L;
        long loadTime = 0L;
        long start = System.currentTimeMillis();
        ArrayList<File> files = ThreadHandler.GetFileList(this.dir);
        if (files.size() <= 0) {
            throw new Exception("Error: no *.rgb files found in the specified directory.");
        }
        CustomThread[] threadArr = new CustomThread[this.threads];
        for (i = 0; i < this.threads; ++i) {
            threadArr[i] = new CustomThread(i + 1, this.lambda);
        }
        for (i = 0; i < files.size(); ++i) {
            bytes += files.get(i).length();
        }
        for (i = 0; i < files.size(); ++i) {
            threadArr[this.getMinimum(threadArr, this.threads)].addFile(files.get(i));
        }
        for (i = 0; i < this.threads; ++i) {
            threadArr[i].start();
        }
        taskTime = System.currentTimeMillis() - start;
        for (i = 0; i < this.threads; ++i) {
            if (!threadArr[i].isAlive()) continue;
            try {
                threadArr[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        for (i = 0; i < this.threads; ++i) {
            System.out.println("Thread " + (i + 1));
            System.out.println("--------------------------");
            System.out.println("Load Time: " + threadArr[i].getLoadTime() + " ms");
            System.out.println("Sharpen Time: " + threadArr[i].getSharpenTime() + " ms");
            System.out.println("Save Time: " + threadArr[i].getSaveTime() + " ms");
            System.out.println("Pixels Processed: " + threadArr[i].getPixels());
            System.out.println("");
            loadTime += threadArr[i].getLoadTime();
            sharpenTime += threadArr[i].getSharpenTime();
            saveTime += threadArr[i].getSaveTime();
        }
        System.out.println("Overall Program");
        System.out.println("--------------------------");
        System.out.println("Task Assignment Time: " + taskTime + " ms");
        System.out.println("Load Time: " + loadTime + " ms");
        System.out.println("Sharpen Time: " + sharpenTime + " ms");
        System.out.println("Save Time: " + saveTime + " ms");
        System.out.println("Pixels: " + (bytes - (long)(4 * files.size())) / 3L);
        return (bytes - (long)(4 * files.size())) / 3L;
    }

    public int getMinimum(CustomThread[] threadArr, int threads) {
        int minIndex = 0;
        long minPixels = threadArr[0].getPixels();
        for (int i = 0; i < threads; ++i) {
            if (minPixels <= threadArr[i].getPixels()) continue;
            minPixels = threadArr[i].getPixels();
            minIndex = i;
        }
        return minIndex;
    }

    public static ArrayList<File> GetFileList(String dir) throws Exception {
        File directory = new File(dir);
        if (!directory.canRead()) {
            throw new Exception("Error: unable to read or open the specified directory. ");
        }
        File[] listing = directory.listFiles();
        ArrayList<File> files = new ArrayList<File>();
        boolean count = false;
        for (int i = 0; i < listing.length; ++i) {
            if (!listing[i].getPath().matches("^.+[.]rgb$")) continue;
            files.add(listing[i]);
        }
        return files;
    }
}

