
package MyProj3;

import java.awt.Color;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;


public class CustomImage {
    private int ci_xres; 
    private int ci_yres; 
    private Color [][] ci_image;
    private int ci_lambda;
    
    /** Creates a new instance of CustomImage */
    public CustomImage() {
        ci_xres = 0;
        ci_yres = 0;
        ci_lambda = 0;
        ci_image = null;
    }

    /* loads the filename provided in to a pixel array */
    public void loadImage(String fileName) {
        try {
            DataInputStream imgfile = new DataInputStream(new FileInputStream(fileName));

            byte [] yindata = new byte[2];
            
            imgfile.read(yindata);
            if (yindata[0] < 0) {
                ci_yres = yindata[0] + 256 + 256 * yindata[1];
            } else {
                ci_yres = yindata[0] + 256 * yindata[1];
            }
            
            byte [] xindata = new byte[2];
            
            imgfile.read(xindata);
            if (xindata[0] < 0) {
                ci_xres = xindata[0] + 256 + 256 * xindata[1];
            } else {
                ci_xres = xindata[0] + 256 * xindata[1];
            }
            
            if ((ci_xres < 0) || (ci_yres < 0)) { return; }
            
            ci_image = new Color[ci_yres][ci_xres];

            for (int ycoor = 0; ycoor < ci_yres; ycoor ++) {
                for (int xcoor = 0; xcoor < ci_xres; xcoor ++) {
                    ci_image[ycoor][xcoor] = new Color(imgfile.readUnsignedByte(),
                                                       imgfile.readUnsignedByte(),
                                                       imgfile.readUnsignedByte());
                }
            }

            imgfile.close();
        } catch (IOException exp) {
            System.out.println("IO error");
        }
    }
    
    /* sets the value of lambda to use for the image conversion */
    public void setLambda(int lambda) {
        ci_lambda = lambda;
    }

    /* saves the current pixel array to a file */
    public void saveFile(String fileName) {
        try {
            DataOutputStream outfile = new DataOutputStream(new FileOutputStream(fileName));
            
            byte [] youtdata = new byte[2];
            byte [] xoutdata = new byte[2];

            Integer intv = new Integer(ci_yres / 256);
            youtdata[1] = intv.byteValue();
            if ((ci_yres % 256) > 127) {
                intv = new Integer((ci_yres % 256) - 256);
                youtdata[0] = intv.byteValue();
            } else {
                intv = new Integer(ci_yres % 256);
                youtdata[0] = intv.byteValue();
            }            
            outfile.write(youtdata);
            
            intv = new Integer(ci_xres / 256);
            xoutdata[1] = intv.byteValue();
            if ((ci_xres % 256) > 127) {
                intv = new Integer((ci_xres % 256) - 256);
                xoutdata[0] = intv.byteValue();
            } else {
                intv = new Integer(ci_xres % 256);
                xoutdata[0] = intv.byteValue();
            }
            outfile.write(xoutdata);
            
            for (int ycoor = 0; ycoor < ci_yres; ycoor ++) {
                for (int xcoor = 0; xcoor < ci_xres; xcoor ++) {
                    outfile.writeByte(ci_image[ycoor][xcoor].getRed());
                    outfile.writeByte(ci_image[ycoor][xcoor].getGreen());
                    outfile.writeByte(ci_image[ycoor][xcoor].getBlue());
                }
            }
            outfile.close();
        } catch (IOException exp) {
            System.out.println("IO error");
        }
    }

    /* sharpens the current pixel array with the value of lambda provided */
    public void sharpenImage() {
        double hmatrix[][];
        int pval = 2;
        double sum = 0;

        hmatrix = new double[2 * pval + 1][2 * pval + 1];
        for (int rowCnt = 0; rowCnt < 2 * pval + 1; rowCnt ++) {
            for (int colCnt = 0; colCnt < 2 * pval + 1; colCnt ++) {
                hmatrix[rowCnt][colCnt] = Math.abs((double)1 - Math.abs((double)(rowCnt - pval) / (pval + 1))) *
                        Math.abs((double) 1 - Math.abs((double)(colCnt - pval) / (pval + 1)));
                sum += hmatrix[rowCnt][colCnt];
            }
        }

        for (int rowCnt = 0; rowCnt < 2 * pval + 1; rowCnt ++) {
            for (int colCnt = 0; colCnt < 2 * pval + 1; colCnt ++) {
                hmatrix[rowCnt][colCnt] /= sum;
            }
        }
        
        for (int rowCnt = 0; rowCnt < 2 * pval + 1; rowCnt ++) {
            for (int colCnt = 0; colCnt < 2 * pval + 1; colCnt ++) {
                hmatrix[rowCnt][colCnt] *= - ci_lambda;
            }
        }
        hmatrix[pval][pval] += (1 + ci_lambda);

        int pixelR;
        int pixelG;
        int pixelB;
        
        for (int ycoor = pval; ycoor < ci_yres - pval; ycoor ++) {
            for (int xcoor = pval; xcoor < ci_xres - pval; xcoor ++) {
                pixelR = 0;
                pixelG = 0;
                pixelB = 0;
                
                for (int m = -pval; m <= pval; m ++) {
                    for (int n = -pval; n <= pval; n++) {
                        pixelR += ci_image[ycoor - m][xcoor - n].getRed() * hmatrix[m + pval][n + pval];
                        pixelG += ci_image[ycoor - m][xcoor - n].getGreen() * hmatrix[m + pval][n + pval];
                        pixelB += ci_image[ycoor - m][xcoor - n].getBlue() * hmatrix[m + pval][n + pval];
                    }
                }
                
                if (pixelR > 255) { pixelR = 255; }
                if (pixelR < 0) { pixelR = 0; }
                if (pixelG > 255) { pixelG = 255; }
                if (pixelG < 0) { pixelG = 0; }
                if (pixelB > 255) { pixelB = 255; }
                if (pixelB < 0) { pixelB = 0; }
                
                ci_image[ycoor][xcoor] = new Color(pixelR, pixelG, pixelB);
            }
        }
    }
}
