
package MyProj3;

import java.io.File;
import java.util.ArrayList;

public class CustomThread extends Thread {
    private CustomImage img;
    private ArrayList<File> files;
    
    private long pixels;
    private int id;
    
    private long loadTime;
    private long sharpenTime;
    private long saveTime;
    
    /** Creates a new instance of CustomThread */
    public CustomThread() { 
        pixels = 0;
        id = 0; 
        loadTime = 0;
        sharpenTime = 0;
        saveTime = 0;
        
        files = new ArrayList<File>();
        img = new CustomImage();
    }
    
    public CustomThread(int id, int lambda) {
        this();

        setLambda(lambda);
        this.id = id; 
    }
    
    /* the function that performs the sharpening of the images and saves them */
    public void run() {
        long start;
        
        if (files.size() <= 0) return;
        
        for (int i = 0; i < files.size(); i++) {
            start = System.currentTimeMillis();
            img.loadImage(files.get(i).getPath());
            loadTime += (System.currentTimeMillis() - start);

            start = System.currentTimeMillis();     
            img.sharpenImage();
            sharpenTime += (System.currentTimeMillis() - start);

            start = System.currentTimeMillis();            
            img.saveFile(files.get(i).getPath().replace(".rgb", "s.rgb"));   
            saveTime += (System.currentTimeMillis() - start);            
        }        
    }
    
    /* 
     *  Just a few setter and getter methods
     */
    public long getPixels() { return pixels; }
    
    public void addFile(File file) { 
        files.add(file); 
        pixels += (file.length() - 4) / 3;
    }
    
    public void setLambda(int lambda) { img.setLambda(lambda); }
    
    public void setThreadId(int id) { this.id = id; }
   
    public long getLoadTime() { return loadTime; }

    public long getSharpenTime() { return sharpenTime; }

    public long getSaveTime() { return saveTime; }
}
