
package MyProj3;

import java.io.File;
import java.util.ArrayList;
import java.lang.Exception;

public class MyProj3 {
    
    public MyProj3() {
    }    
   
    public static void main(String[] args) {
        String dir = "";
        int threads = 0;
        int lambda = 0;
        int valid_args = 0;
        long start, end;
      
        start = System.currentTimeMillis();
        
            // in this try-catch block, all possible exceptions are handled
        
           try {
                if (args.length != 3) {
                throw new Exception("Error: the number of arguments is not three. ");
                }          
            
                // loop through and get the three command line options
                for (int argcnt = 0; argcnt < args.length; argcnt ++) {
                  // get the directory to batch process
                  if (args[argcnt].length() > 5 && args[argcnt].substring(0, 5).equals("-dir=")) {
                      dir = args[argcnt].substring(5);
                      valid_args++;
                  // get the lambda value for the processing
                  } else if (args[argcnt].length() > 8 && args[argcnt].substring(0, 8).equals("-lambda=")) {
                         try {
                             lambda = Integer.parseInt(args[argcnt].substring(8));
                             valid_args++;
                         } catch (NumberFormatException nfe) {
                              throw new Exception("Error: converting the value of lambda from String to Int failed. ");
                         }
                  // get the number of threads to use
                  } else if (args[argcnt].length() > 8 && args[argcnt].substring(0, 8).equals("-thread=")) {
                         try {
                             threads = Integer.parseInt(args[argcnt].substring(8));
                             valid_args++;
                         } catch (NumberFormatException nfe) {
                             throw new Exception("Error: converting the value of threads from String to Int failed. "); 
                         }
                    }
                }     // for argcnt loop
            
                // perform some error checking on the values received
                if (valid_args != 3) {
                    throw new Exception("Error: the three arguments are not -dir=..., -thread=..., -lambda=... "); 
                }
                
                if (lambda < 0 || lambda > 10) { 
                    throw new Exception("Error: the value of lambda must be between 0 and 10. "); 
                }
                
                if (threads < 1 || threads > 8) { 
                    throw new Exception("Error the number of threads should be between 1 and 8. "); 
                }
                
                // create the thread handler to distribute and process the images
                ThreadHandler th = new ThreadHandler(dir, lambda, threads);
                long pixels = th.BatchProcess();           

                end = System.currentTimeMillis();
  
                // output the execution time and performace of the batch process
                System.out.println("Execution Time: " + (end - start) + " ms");
                System.out.println("Performance: " + ((end - start) * 1000) / pixels + " us/pixel");
            } catch (Exception e) {
                System.err.println(e.getMessage() + " The program will terminate now.");           
            }
      
     }  // main
}
