
package MyProj3;

import java.io.File;
import java.util.ArrayList;

public class ThreadHandler {
    private String dir;
    private int lambda;
    private int threads;
    
    /** Creates a new instance of ThreadHandler */
    public ThreadHandler(String dir, int lambda, int threads) {
        this.dir = dir;
        this.lambda = lambda;
        this.threads = threads;
    }
    
    /* searches through the directory set, splits the images among threads and
       starts the threads */
    public long BatchProcess() throws Exception{
        CustomThread [] threadArr;
        ArrayList<File> files;
        long bytes = 0;
        long taskTime = 0;
        long sharpenTime = 0;
        long saveTime = 0;
        long loadTime = 0;
        long start;
        int  i,
             j;
        
        start = System.currentTimeMillis();
        
        files = GetFileList(dir);
        if (files.size() <= 0) { throw new Exception("Error: no *.rgb files found in the specified directory."); }        
        
        threadArr = new CustomThread[threads];
        for (i = 0; i < threads; i++) {
            threadArr[i] = new CustomThread(i + 1, lambda);
        }
        
        for (i = 0; i < files.size(); i++) { bytes += files.get(i).length(); }        

        for (i = 0; i < files.size(); i++) {
            threadArr[getMinimum(threadArr, threads)].addFile(files.get(i));
        }      
        
        for (i = 0; i < threads; i++) { threadArr[i].start(); }
        taskTime = (System.currentTimeMillis() - start);
        
        for (i = 0; i < threads; i++) {
            if (threadArr[i].isAlive() == true) { 
                try {
                    threadArr[i].join(); 
                } catch (InterruptedException ie) { }
            }
        }            

        for (i = 0; i < threads; i++) {
            System.out.println("Thread " + (i + 1));
            System.out.println("--------------------------");
            System.out.println("Load Time: " + threadArr[i].getLoadTime() + " ms");
            System.out.println("Sharpen Time: " + threadArr[i].getSharpenTime() + " ms");
            System.out.println("Save Time: " + threadArr[i].getSaveTime() + " ms");
            System.out.println("Pixels Processed: " + threadArr[i].getPixels());
            System.out.println("");
            
            loadTime += threadArr[i].getLoadTime();
            sharpenTime += threadArr[i].getSharpenTime();
            saveTime += threadArr[i].getSaveTime();
        }
        
        System.out.println("Overall Program");
        System.out.println("--------------------------");
        System.out.println("Task Assignment Time: " + taskTime + " ms");
        System.out.println("Load Time: " + loadTime + " ms");
        System.out.println("Sharpen Time: " + sharpenTime + " ms");
        System.out.println("Save Time: " + saveTime + " ms");
        System.out.println("Pixels: " + (bytes - 4*files.size()) / 3);
        
        return (bytes - 4*files.size()) / 3;
    }    
    
    /* returns the index of the thread which was assigned the smallest number of pixels */
            
    public int getMinimum(CustomThread [] threadArr, int threads) {
        int minIndex = 0;
        long minPixels = threadArr[0].getPixels();        
        for (int i = 0; i < threads; i++) {           
           if (minPixels > threadArr[i].getPixels()) {
                minPixels = threadArr[i].getPixels();
                minIndex = i;
            }
        }
        return minIndex;
    }
    
    public static ArrayList<File> GetFileList(String dir) throws Exception {
        File directory = new File(dir);    
        
        if (directory.canRead() == false) {
            throw new Exception("Error: unable to read or open the specified directory. ");
        }
        
        File [] listing = directory.listFiles(); 
        ArrayList<File> files = new ArrayList<File>();
        int count = 0;                          
        
        for (int i = 0; i < listing.length; i++) {
            if (listing[i].getPath().matches("^.+[.]rgb$")) {
                files.add(listing[i]);
            }
        }

        return files;
    } 
}
