% Author: Prof. Yung-Hsiang Lu

function success = saveimage(inimage, filename)
% save an image in rgb format, no compression
%
% CVS log at the end of file
% 
% image format: (binary)
% 2 bytes: x resolution
% 2 bytes: y resolution
% 3 bytes for each pixel (RGB)

% valid image file?
if (max(max(max(inimage))) > 255) % pixel value > 255
	% need three max:
	% first max for row
	% second max for column
	% third gets for color
	error ('maximum value exceeds 255');
	success = -1;
	return;
end

if (min(min(min(inimage))) < 0) 
	error ('minimum value below 0');
	success = -1;
	return;
end

resolution = size(inimage); % first two numbers are the resolution
dimesion = size(resolution); % if RGB, the second number is 3
if (dimesion(2) == 2) % gray level now, convert to RGB (gray)
	for xcoor = 1:resolution(1)
		for ycoor = 1:resolution(2)		
			rgbimage(xcoor,ycoor,1) = inimage(xcoor,ycoor);
			rgbimage(xcoor,ycoor,2) = inimage(xcoor,ycoor);
			rgbimage(xcoor,ycoor,3) = inimage(xcoor,ycoor);
		end
	end
else
	rgbimage = inimage;
end

xysize = resolution(1:2);
fid = fopen(filename, 'wb');
% first, store the resolution
fwrite(fid, xysize, 'integer*2'); % 2-byte integer (short for Java)
% second, store the RGB values
%
% cannot use fwrite(fid, rgbimage, 'ubit8'); 
% because it stores one color each time, not in RGB order
%
for xcoor = 1:resolution(1) 
	for ycoor = 1:resolution(2)		
		for cplane = 1:3 % color plane
			fwrite(fid, rgbimage(xcoor, ycoor, cplane), 'uint8'); % unsigned integer of 8 bits
		end
	end
end
fclose(fid);
success = 1; % successful
%
% $Log: saveimage.m,v $
% Revision 1.7  2006/04/23 18:31:19  yunglu
% return if failure (after assigning -1 to success)
%
% Revision 1.6  2006/04/21 21:02:32  yunglu
% comment about output file format
%
% Revision 1.5  2006/04/21 18:47:22  yunglu
% fix a major problem: fwrite(fid, rgbimage, 'ubit8') saves one color at a time, not in RGB order. now, the colors are saved together
%
% Revision 1.4  2006/04/20 20:57:51  yunglu
% somewhat working, can be read in Java. have problems handling color images
%
% 

