function varargout = Finite_Difference_Pricing(varargin)
% FINITE_DIFFERENCE_PRICING M-file for Finite_Difference_Pricing.fig
%      FINITE_DIFFERENCE_PRICING, by itself, creates a new FINITE_DIFFERENCE_PRICING or raises the existing
%      singleton*.
%
%      H = FINITE_DIFFERENCE_PRICING returns the handle to a new FINITE_DIFFERENCE_PRICING or the handle to
%      the existing singleton*.
%
%      FINITE_DIFFERENCE_PRICING('CALLBACK',hObject,eventData,handles,...) calls the local
%      function named CALLBACK in FINITE_DIFFERENCE_PRICING.M with the given input arguments.
%
%      FINITE_DIFFERENCE_PRICING('Property','Value',...) creates a new FINITE_DIFFERENCE_PRICING or raises the
%      existing singleton*.  Starting from the left, property value pairs are
%      applied to the GUI before Finite_Difference_Pricing_OpeningFcn gets called.  An
%      unrecognized property name or invalid value makes property application
%      stop.  All inputs are passed to Finite_Difference_Pricing_OpeningFcn via varargin.
%
%      *See GUI Options on GUIDE's Tools menu.  Choose "GUI allows only one
%      instance to run (singleton)".
%
% See also: GUIDE, GUIDATA, GUIHANDLES

% Edit the above text to modify the response to help Finite_Difference_Pricing

% Last Modified by GUIDE v2.5 28-Jul-2010 23:04:18

% Begin initialization code - DO NOT EDIT
gui_Singleton = 1;
gui_State = struct('gui_Name',       mfilename, ...
                   'gui_Singleton',  gui_Singleton, ...
                   'gui_OpeningFcn', @Finite_Difference_Pricing_OpeningFcn, ...
                   'gui_OutputFcn',  @Finite_Difference_Pricing_OutputFcn, ...
                   'gui_LayoutFcn',  [] , ...
                   'gui_Callback',   []);
if nargin && ischar(varargin{1})
    gui_State.gui_Callback = str2func(varargin{1});
end

if nargout
    [varargout{1:nargout}] = gui_mainfcn(gui_State, varargin{:});
else
    gui_mainfcn(gui_State, varargin{:});
end
% End initialization code - DO NOT EDIT


% --- Executes just before Finite_Difference_Pricing is made visible.
function Finite_Difference_Pricing_OpeningFcn(hObject, eventdata, handles, varargin)
    % This function has no output args, see OutputFcn.
    % hObject    handle to figure
    % eventdata  reserved - to be defined in a future version of MATLAB
    % handles    structure with handles and user data (see GUIDATA)
    % varargin   command line arguments to Finite_Difference_Pricing (see VARARGIN)

    % Load the data to plot:
    load('plotdata.mat', 'data');
    handles.data = data;
    mesh(handles.data.space, handles.data.time, handles.data.vanilla_euro_call),
    xlabel('N, number of space nodes'), ylabel('M, number of time nodes'), 
    zlabel('Pricing error, $'), 
    title('Pricing error for Vanilla European Call, F = max \{ S - K, 0 \}'), 
    grid on;  

    % Choose default command line output for Finite_Difference_Pricing
    handles.output = hObject;

    % Update handles structure
    guidata(hObject, handles);

    % UIWAIT makes Finite_Difference_Pricing wait for user response (see UIRESUME)
    % uiwait(handles.figure1);


% --- Outputs from this function are returned to the command line.
function varargout = Finite_Difference_Pricing_OutputFcn(hObject, eventdata, handles) 
% varargout  cell array for returning output args (see VARARGOUT);
% hObject    handle to figure
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)

% Get default command line output from handles structure
varargout{1} = handles.output;


% --- Executes on selection change in Popup_menu.
function Popup_menu_Callback(hObject, eventdata, handles)
% hObject    handle to Popup_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    structure with handles and user data (see GUIDATA)
    str = get(hObject, 'String');
    val = get(hObject,'Value');
    switch str{val};
        case 'Vanilla European Call' % User selects peaks.
            mesh(handles.data.space, handles.data.time, handles.data.vanilla_euro_call),
            xlabel('N, number of space nodes'), ylabel('M, number of time nodes'), 
            zlabel('Pricing error, $'), 
            title('Pricing error for Vanilla European Call, F = max \{ S - K, 0 \}'), 
            grid on;
        case 'Exotic European Call'
            mesh(handles.data.space, handles.data.time, handles.data.exotic_euro_call),
            xlabel('N, number of space nodes'), ylabel('M, number of time nodes'), 
            zlabel('Price, $'), 
            title('Price of Exotic European call, F = max \{ S + sqrt(S) - K, 0 \}'), 
            grid on;
        case 'Vanilla American Put'
            mesh(handles.data.space, handles.data.time, handles.data.vanilla_amer_put),
            xlabel('N, number of space nodes'), ylabel('M, number of time nodes'), 
            zlabel('Price, $'), title('Price of Vanilla American Put, F = max \{K - S, 0 \}'), grid on;
        case 'Exotic American Option'
            mesh(handles.data.space, handles.data.time, handles.data.exotic_amer_put),
            xlabel('N, number of space nodes'), ylabel('M, number of time nodes'), 
            zlabel('Price, $'), title('Price of Exotic American Option, F = 10 * SIN( S / 100 )'), grid on;
    end
    % Save the handles structure.
    guidata(hObject,handles)

% Hints: contents = get(hObject,'String') returns Popup_menu contents as cell array
%        contents{get(hObject,'Value')} returns selected item from Popup_menu


% --- Executes during object creation, after setting all properties.
function Popup_menu_CreateFcn(hObject, eventdata, handles)
% hObject    handle to Popup_menu (see GCBO)
% eventdata  reserved - to be defined in a future version of MATLAB
% handles    empty - handles not created until after all CreateFcns called

% Hint: popupmenu controls usually have a white background on Windows.
%       See ISPC and COMPUTER.
if ispc && isequal(get(hObject,'BackgroundColor'), get(0,'defaultUicontrolBackgroundColor'))
    set(hObject,'BackgroundColor','white');
end
